/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.font.container;

import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.preflight.font.container.FontContainer;
import org.apache.pdfbox.preflight.font.util.CIDToGIDMap;

public class CIDType2Container
extends FontContainer {
    protected CIDToGIDMap cidToGid = null;
    protected TrueTypeFont ttf = null;

    public CIDType2Container(PDFont font) {
        super(font);
    }

    protected float getFontProgramWidth(int cid) {
        float foundWidth = -1.0f;
        int glyphIndex = this.getGlyphIndex(cid);
        if (this.ttf != null && this.ttf.getGlyph().getGlyphs().length > glyphIndex) {
            int numberOfLongHorMetrics = this.ttf.getHorizontalHeader().getNumberOfHMetrics();
            int unitsPerEm = this.ttf.getHeader().getUnitsPerEm();
            int[] advanceGlyphWidths = this.ttf.getHorizontalMetrics().getAdvanceWidth();
            float glypdWidth = advanceGlyphWidths[numberOfLongHorMetrics - 1];
            if (glyphIndex < numberOfLongHorMetrics) {
                glypdWidth = advanceGlyphWidths[glyphIndex];
            }
            foundWidth = glypdWidth * 1000.0f / (float)unitsPerEm;
        }
        return foundWidth;
    }

    private int getGlyphIndex(int cid) {
        int glyphIndex = cid;
        if (this.cidToGid != null && (glyphIndex = this.cidToGid.getGID(cid)) == this.cidToGid.NOTDEF_GLYPH_INDEX) {
            glyphIndex = -14;
        }
        return glyphIndex;
    }

    public void setCidToGid(CIDToGIDMap cidToGid) {
        this.cidToGid = cidToGid;
    }

    public void setTtf(TrueTypeFont ttf) {
        this.ttf = ttf;
    }
}

