/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.font;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.encoding.DictionaryEncoding;
import org.apache.pdfbox.encoding.Encoding;
import org.apache.pdfbox.encoding.EncodingManager;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontFactory;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.PreflightPath;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.content.ContentStreamException;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.font.FontValidator;
import org.apache.pdfbox.preflight.font.container.FontContainer;
import org.apache.pdfbox.preflight.font.container.Type3Container;
import org.apache.pdfbox.preflight.font.util.GlyphException;
import org.apache.pdfbox.preflight.font.util.PDFAType3StreamParser;
import org.apache.pdfbox.preflight.utils.COSUtils;
import org.apache.pdfbox.preflight.utils.ContextHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Type3FontValidator
extends FontValidator<Type3Container> {
    protected COSDictionary fontDictionary;
    protected COSDocument cosDocument;
    protected Encoding encoding;

    public Type3FontValidator(PreflightContext context, PDFont font) {
        super(context, font, new Type3Container(font));
        this.cosDocument = context.getDocument().getDocument();
        this.fontDictionary = (COSDictionary)font.getCOSObject();
    }

    @Override
    public void validate() throws ValidationException {
        this.checkMandatoryField();
        this.checkFontBBox();
        this.checkFontMatrix();
        this.checkEncoding();
        this.checkResources();
        this.checkCharProcsAndMetrics();
        this.checkToUnicode();
    }

    protected void checkMandatoryField() {
        boolean areFieldsPResent = this.fontDictionary.containsKey(COSName.FONT_BBOX);
        areFieldsPResent &= this.fontDictionary.containsKey(COSName.FONT_MATRIX);
        areFieldsPResent &= this.fontDictionary.containsKey(COSName.CHAR_PROCS);
        areFieldsPResent &= this.fontDictionary.containsKey(COSName.ENCODING);
        areFieldsPResent &= this.fontDictionary.containsKey(COSName.FIRST_CHAR);
        areFieldsPResent &= this.fontDictionary.containsKey(COSName.LAST_CHAR);
        if (!(areFieldsPResent &= this.fontDictionary.containsKey(COSName.WIDTHS))) {
            ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.1", "Some required fields are missing from the Font dictionary."));
        }
    }

    private void checkFontBBox() {
        COSBase fontBBox = this.fontDictionary.getItem(COSName.FONT_BBOX);
        if (!COSUtils.isArray(fontBBox, this.cosDocument)) {
            ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.1", "The FontBBox element isn't an array"));
            return;
        }
        COSArray bbox = COSUtils.getAsArray(fontBBox, this.cosDocument);
        if (bbox.size() != 4) {
            ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.1", "The FontBBox element is invalid"));
            return;
        }
        for (int i = 0; i < 4; ++i) {
            COSBase elt = bbox.get(i);
            if (COSUtils.isFloat(elt, this.cosDocument) || COSUtils.isInteger(elt, this.cosDocument)) continue;
            ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.1", "An element of FontBBox isn't a number"));
            return;
        }
    }

    private void checkFontMatrix() {
        COSBase fontMatrix = this.fontDictionary.getItem(COSName.FONT_MATRIX);
        if (!COSUtils.isArray(fontMatrix, this.cosDocument)) {
            ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.1", "The FontMatrix element isn't an array"));
            return;
        }
        COSArray matrix = COSUtils.getAsArray(fontMatrix, this.cosDocument);
        if (matrix.size() != 6) {
            ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.1", "The FontMatrix element is invalid"));
            return;
        }
        for (int i = 0; i < 6; ++i) {
            COSBase elt = matrix.get(i);
            if (COSUtils.isFloat(elt, this.cosDocument) || COSUtils.isInteger(elt, this.cosDocument)) continue;
            ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.1", "An element of FontMatrix isn't a number"));
            return;
        }
    }

    @Override
    protected void checkEncoding() {
        COSBase fontEncoding = this.fontDictionary.getItem(COSName.ENCODING);
        if (COSUtils.isString(fontEncoding, this.cosDocument)) {
            this.checkEncodingAsString(fontEncoding);
        } else if (COSUtils.isDictionary(fontEncoding, this.cosDocument)) {
            this.checkEncodingAsDictionary(fontEncoding);
        } else {
            ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.2.4", "The Encoding entry doesn't have the right type"));
        }
    }

    private void checkEncodingAsString(COSBase fontEncoding) {
        EncodingManager emng = new EncodingManager();
        String enc = COSUtils.getAsString(fontEncoding, this.cosDocument);
        try {
            this.encoding = emng.getEncoding(COSName.getPDFName((String)enc));
        }
        catch (IOException e) {
            ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.5"));
            return;
        }
    }

    private void checkEncodingAsDictionary(COSBase fontEncoding) {
        COSDictionary encodingDictionary = COSUtils.getAsDictionary(fontEncoding, this.cosDocument);
        try {
            this.encoding = new DictionaryEncoding(encodingDictionary);
        }
        catch (IOException e) {
            ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.5"));
            return;
        }
    }

    private void checkCharProcsAndMetrics() throws ValidationException {
        List widths = this.font.getWidths();
        if (widths == null || widths.isEmpty()) {
            ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.1", "The Witdhs array is unreachable"));
            return;
        }
        COSDictionary charProcs = COSUtils.getAsDictionary(this.fontDictionary.getItem(COSName.CHAR_PROCS), this.cosDocument);
        if (charProcs == null) {
            ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.1", "The CharProcs element isn't a dictionary"));
            return;
        }
        int fc = this.font.getFirstChar();
        int lc = this.font.getLastChar();
        int expectedLength = lc - fc + 1;
        if (widths.size() != expectedLength) {
            ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.1", "The length of Witdhs array is invalid. Expected : \"" + expectedLength + "\" Current : \"" + widths.size() + "\""));
            return;
        }
        PDResources pResources = this.getPDResources();
        for (int i = 0; i < expectedLength; ++i) {
            int cid = fc + i;
            float width = ((Float)widths.get(i)).floatValue();
            COSStream charStream = this.getCharacterStreamDescription(cid, charProcs);
            if (charStream == null) continue;
            try {
                float fontProgamWidth = this.getWidthFromCharacterStream(pResources, charStream);
                if (width == fontProgamWidth) {
                    ((Type3Container)this.fontContainer).markCIDAsValid(cid);
                    continue;
                }
                GlyphException glyphEx = new GlyphException("3.1.6", cid, "The character with CID\"" + cid + "\" should have a width equals to " + width);
                ((Type3Container)this.fontContainer).markCIDAsInvalid(cid, glyphEx);
                continue;
            }
            catch (ContentStreamException e) {
                this.context.addValidationError(new ValidationResult.ValidationError(e.getErrorCode(), e.getMessage()));
                return;
            }
            catch (IOException e) {
                ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.2.4", "The CharProcs references an element which can't be read"));
                return;
            }
        }
    }

    private PDResources getPDResources() {
        COSBase res = this.fontDictionary.getItem(COSName.RESOURCES);
        PDResources pResources = null;
        COSDictionary resAsDict = COSUtils.getAsDictionary(res, this.cosDocument);
        if (resAsDict != null) {
            pResources = new PDResources(resAsDict);
        }
        return pResources;
    }

    private COSStream getCharacterStreamDescription(int cid, COSDictionary charProcs) throws ValidationException {
        String charName = this.getCharNameFromEncoding(cid);
        COSBase item = charProcs.getItem(COSName.getPDFName((String)charName));
        COSStream charStream = COSUtils.getAsStream(item, this.cosDocument);
        if (charStream == null) {
            GlyphException glyphEx = new GlyphException("3.1.6", cid, "The CharProcs \"" + charName + "\" doesn't exist");
            ((Type3Container)this.fontContainer).markCIDAsInvalid(cid, glyphEx);
        }
        return charStream;
    }

    private String getCharNameFromEncoding(int cid) throws ValidationException {
        try {
            return this.encoding.getName(cid);
        }
        catch (IOException e) {
            throw new ValidationException("Unable to check Widths consistency", e);
        }
    }

    private float getWidthFromCharacterStream(PDResources resources, COSStream charStream) throws IOException {
        PreflightPath vPath = this.context.getValidationPath();
        PDFAType3StreamParser parser = new PDFAType3StreamParser(this.context, vPath.getClosestPathElement(PDPage.class));
        parser.resetEngine();
        parser.processSubStream(null, resources, charStream);
        return parser.getWidth();
    }

    private void checkResources() throws ValidationException {
        COSBase resources = this.fontDictionary.getItem(COSName.RESOURCES);
        if (resources != null) {
            COSDictionary dictionary = COSUtils.getAsDictionary(resources, this.cosDocument);
            if (dictionary == null) {
                ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.1", "The Resources element isn't a dictionary"));
                return;
            }
            ContextHelper.validateElement(this.context, new PDResources(dictionary), "resources-process");
            COSBase cbFont = dictionary.getItem(COSName.FONT);
            if (cbFont != null) {
                COSDictionary dicFonts = COSUtils.getAsDictionary(cbFont, this.cosDocument);
                Set keyList = dicFonts.keySet();
                for (COSName key : keyList) {
                    COSBase item = dicFonts.getItem(key);
                    COSDictionary xObjFont = COSUtils.getAsDictionary(item, this.cosDocument);
                    try {
                        PDFont aFont = PDFontFactory.createFont((COSDictionary)xObjFont);
                        FontContainer aContainer = this.context.getFontContainer(aFont.getCOSObject());
                        if (aContainer.isValid()) continue;
                        ((Type3Container)this.fontContainer).push(new ValidationResult.ValidationError("3.2.4", "The Resources dictionary of type 3 font contains invalid font"));
                    }
                    catch (IOException e) {
                        this.context.addValidationError(new ValidationResult.ValidationError("3.2", "Unable to valid the Type3 : " + e.getMessage()));
                    }
                }
            }
        }
    }
}

