/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.font;

import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.font.FontValidator;
import org.apache.pdfbox.preflight.font.container.FontContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleFontValidator<T extends FontContainer>
extends FontValidator<T> {
    public SimpleFontValidator(PreflightContext context, PDFont font, T fContainer) {
        super(context, font, fContainer);
    }

    @Override
    public void validate() throws ValidationException {
        this.checkMandatoryField();
        this.createFontDescriptorHelper();
        this.processFontDescriptorValidation();
        this.checkEncoding();
        this.checkToUnicode();
    }

    protected void checkMandatoryField() {
        COSDictionary fontDictionary = (COSDictionary)this.font.getCOSObject();
        boolean areFieldsPResent = fontDictionary.containsKey(COSName.TYPE);
        areFieldsPResent &= fontDictionary.containsKey(COSName.SUBTYPE);
        areFieldsPResent &= fontDictionary.containsKey(COSName.BASE_FONT);
        areFieldsPResent &= fontDictionary.containsKey(COSName.FIRST_CHAR);
        areFieldsPResent &= fontDictionary.containsKey(COSName.LAST_CHAR);
        if (!(areFieldsPResent &= fontDictionary.containsKey(COSName.WIDTHS))) {
            this.fontContainer.push(new ValidationResult.ValidationError("3.1.1", "Some required fields are missing from the Font dictionary."));
        }
    }

    protected abstract void createFontDescriptorHelper();

    protected void processFontDescriptorValidation() {
        this.descriptorHelper.validate();
    }
}

