/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.process;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.persistence.util.COSObjectKey;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.PreflightDocument;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.process.AbstractProcess;
import org.apache.pdfbox.preflight.utils.COSUtils;
import org.apache.pdfbox.preflight.utils.FilterHelper;

public class StreamValidationProcess
extends AbstractProcess {
    public void validate(PreflightContext ctx) throws ValidationException {
        PreflightDocument pdfDoc = ctx.getDocument();
        COSDocument cDoc = pdfDoc.getDocument();
        List lCOSObj = cDoc.getObjects();
        for (Object o : lCOSObj) {
            COSObject cObj = (COSObject)o;
            COSBase cBase = cObj.getObject();
            if (!(cBase instanceof COSStream)) continue;
            this.validateStreamObject(ctx, cObj);
        }
    }

    public void validateStreamObject(PreflightContext context, COSObject cObj) throws ValidationException {
        COSStream streamObj = (COSStream)cObj.getObject();
        this.checkDictionaryEntries(context, streamObj);
        this.checkStreamLength(context, cObj);
        this.checkFilters(streamObj, context);
    }

    protected void checkFilters(COSStream stream, PreflightContext context) {
        COSBase bFilter = stream.getDictionaryObject(COSName.FILTER);
        if (bFilter != null) {
            COSDocument cosDocument = context.getDocument().getDocument();
            if (COSUtils.isArray(bFilter, cosDocument)) {
                COSArray afName = (COSArray)bFilter;
                for (int i = 0; i < afName.size(); ++i) {
                    FilterHelper.isAuthorizedFilter(context, afName.getString(i));
                }
            } else if (bFilter instanceof COSName) {
                String fName = ((COSName)bFilter).getName();
                FilterHelper.isAuthorizedFilter(context, fName);
            } else {
                this.addValidationError(context, new ValidationResult.ValidationError("1.2.7", "Filter should be a Name or an Array"));
            }
        }
    }

    private boolean readUntilStream(InputStream ra) throws IOException {
        boolean search = true;
        boolean maybe = false;
        int lastChar = -1;
        do {
            int c = ra.read();
            switch (c) {
                case 115: {
                    maybe = true;
                    lastChar = c;
                    break;
                }
                case 116: {
                    if (maybe && lastChar == 115) {
                        lastChar = c;
                        break;
                    }
                    maybe = false;
                    lastChar = -1;
                    break;
                }
                case 114: {
                    if (maybe && lastChar == 116) {
                        lastChar = c;
                        break;
                    }
                    maybe = false;
                    lastChar = -1;
                    break;
                }
                case 101: {
                    if (maybe && lastChar == 114) {
                        lastChar = c;
                        break;
                    }
                    maybe = false;
                    break;
                }
                case 97: {
                    if (maybe && lastChar == 101) {
                        lastChar = c;
                        break;
                    }
                    maybe = false;
                    break;
                }
                case 109: {
                    if (maybe && lastChar == 97) {
                        return true;
                    }
                    maybe = false;
                    break;
                }
                case -1: {
                    search = false;
                    break;
                }
                default: {
                    maybe = false;
                }
            }
        } while (search);
        return false;
    }

    protected void checkStreamLength(PreflightContext context, COSObject cObj) throws ValidationException {
        COSStream streamObj = (COSStream)cObj.getObject();
        int length = streamObj.getInt(COSName.LENGTH);
        InputStream ra = null;
        try {
            ra = context.getSource().getInputStream();
            Long offset = (Long)context.getDocument().getDocument().getXrefTable().get(new COSObjectKey(cObj));
            if (offset != null) {
                long curSkip;
                for (long skipped = 0L; skipped != offset; skipped += curSkip) {
                    curSkip = ra.skip(offset - skipped);
                    if (curSkip >= 0L) continue;
                    IOUtils.closeQuietly((InputStream)ra);
                    this.addValidationError(context, new ValidationResult.ValidationError("1.2.13", "Unable to skip bytes in the PDFFile to check stream length"));
                    return;
                }
                if (this.readUntilStream(ra)) {
                    int cr;
                    int c = ra.read();
                    if (c == 13) {
                        ra.read();
                    }
                    byte[] buffer = new byte[1024];
                    int nbBytesToRead = length;
                    do {
                        cr = 0;
                        cr = nbBytesToRead > 1024 ? ra.read(buffer, 0, 1024) : ra.read(buffer, 0, nbBytesToRead);
                        if (cr != -1) continue;
                        this.addValidationError(context, new ValidationResult.ValidationError("1.2.5", "Stream length is invalid"));
                        IOUtils.closeQuietly((InputStream)ra);
                        return;
                    } while ((nbBytesToRead -= cr) > 0);
                    int len = "endstream".length() + 2;
                    byte[] buffer2 = new byte[len];
                    for (int i = 0; i < len; ++i) {
                        buffer2[i] = (byte)ra.read();
                    }
                    String endStream = new String(buffer2, "ISO-8859-1");
                    if (buffer2[0] == 13 && buffer2[1] == 10) {
                        if (!endStream.contains("endstream")) {
                            this.addValidationError(context, new ValidationResult.ValidationError("1.2.5", "Stream length is invalid"));
                        }
                    } else if (buffer2[0] == 13 && buffer2[1] == 101) {
                        if (!endStream.contains("endstream")) {
                            this.addValidationError(context, new ValidationResult.ValidationError("1.2.5", "Stream length is invalid"));
                        }
                    } else if (buffer2[0] == 10 && buffer2[1] == 101) {
                        if (!endStream.contains("endstream")) {
                            this.addValidationError(context, new ValidationResult.ValidationError("1.2.5", "Stream length is invalid"));
                        }
                    } else {
                        this.addValidationError(context, new ValidationResult.ValidationError("1.2.5", "Stream length is invalid"));
                    }
                } else {
                    this.addValidationError(context, new ValidationResult.ValidationError("1.2.5", "Stream length is invalid"));
                }
            }
        }
        catch (IOException e) {
            throw new ValidationException("Unable to read a stream to validate it due to : " + e.getMessage(), e);
        }
        finally {
            if (ra != null) {
                org.apache.commons.io.IOUtils.closeQuietly((InputStream)ra);
            }
        }
    }

    protected void checkDictionaryEntries(PreflightContext context, COSStream streamObj) {
        boolean len = streamObj.containsKey(COSName.LENGTH);
        boolean f = streamObj.containsKey(COSName.F);
        boolean ffilter = streamObj.containsKey(COSName.F_FILTER);
        boolean fdecParams = streamObj.containsKey(COSName.F_DECODE_PARMS);
        if (!len) {
            this.addValidationError(context, new ValidationResult.ValidationError("1.2.4", "Stream length is missing"));
        }
        if (f || ffilter || fdecParams) {
            this.addValidationError(context, new ValidationResult.ValidationError("1.2.6", "F, FFilter or FDecodeParms keys are present in the stream dictionary"));
        }
    }
}

