/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.font;

import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.exception.ValidationException;
import org.apache.pdfbox.preflight.font.container.FontContainer;
import org.apache.pdfbox.preflight.font.descriptor.FontDescriptorHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FontValidator<T extends FontContainer> {
    protected T fontContainer;
    protected PreflightContext context;
    protected PDFont font;
    protected FontDescriptorHelper<T> descriptorHelper;
    private static final String SUB_SET_PATTERN = "^[A-Z]{6}\\+.*";

    public FontValidator(PreflightContext context, PDFont font, T fContainer) {
        this.context = context;
        this.font = font;
        this.fontContainer = fContainer;
        this.context.addFontContainer(font.getCOSObject(), (FontContainer)fContainer);
    }

    public static boolean isSubSet(String fontName) {
        return fontName != null && fontName.matches(SUB_SET_PATTERN);
    }

    public static String getSubSetPatternDelimiter() {
        return "\\+";
    }

    public abstract void validate() throws ValidationException;

    protected void checkEncoding() {
    }

    protected void checkToUnicode() {
    }

    public T getFontContainer() {
        return this.fontContainer;
    }
}

