/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.font.container;

import java.io.IOException;
import java.util.List;
import org.apache.fontbox.cff.CFFFont;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.preflight.font.container.FontContainer;
import org.apache.pdfbox.preflight.font.util.GlyphException;
import org.apache.pdfbox.preflight.font.util.Type1;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Type1Container
extends FontContainer {
    private float defaultGlyphWidth = 0.0f;
    protected boolean isFontFile1 = true;
    protected Type1 type1Font;
    protected List<CFFFont> lCFonts;

    public Type1Container(PDFont font) {
        super(font);
    }

    @Override
    protected float getFontProgramWidth(int cid) {
        float widthResult;
        block7: {
            widthResult = -1.0f;
            try {
                if (this.isFontFile1) {
                    if (this.type1Font != null) {
                        widthResult = this.type1Font.getWidthOfCID(cid);
                    }
                    break block7;
                }
                String name = this.font.getFontEncoding().getName(cid);
                for (CFFFont cff : this.lCFonts) {
                    int SID = cff.getEncoding().getSID(cid);
                    for (CFFFont.Mapping m : cff.getMappings()) {
                        if (!m.getName().equals(name)) continue;
                        SID = m.getSID();
                        break;
                    }
                    if ((widthResult = (float)cff.getWidth(SID)) == this.defaultGlyphWidth) continue;
                    break;
                }
            }
            catch (GlyphException e) {
                widthResult = -1.0f;
            }
            catch (IOException e) {
                widthResult = -1.0f;
            }
        }
        return widthResult;
    }

    public void setType1Font(Type1 type1Font) {
        this.type1Font = type1Font;
    }

    public void setFontFile1(boolean isFontFile1) {
        this.isFontFile1 = isFontFile1;
    }

    public void setCFFFontObjects(List<CFFFont> lCFonts) {
        this.lCFonts = lCFonts;
    }
}

