/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.rendering;

import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.contentstream.PDFGraphicsStreamEngine;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.image.PDImage;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.Vector;

public class CustomGraphicsStreamEngine
extends PDFGraphicsStreamEngine {
    protected CustomGraphicsStreamEngine(PDPage page) {
        super(page);
    }

    public static void main(String[] args) throws IOException {
        File file = new File("src/main/resources/org/apache/pdfbox/examples/rendering/", "custom-render-demo.pdf");
        try (PDDocument doc = Loader.loadPDF((File)file);){
            PDPage page = doc.getPage(0);
            CustomGraphicsStreamEngine engine = new CustomGraphicsStreamEngine(page);
            engine.run();
        }
    }

    public void run() throws IOException {
        this.processPage(this.getPage());
        for (PDAnnotation annotation : this.getPage().getAnnotations()) {
            this.showAnnotation(annotation);
        }
    }

    public void appendRectangle(Point2D p0, Point2D p1, Point2D p2, Point2D p3) throws IOException {
        System.out.printf("appendRectangle %.2f %.2f, %.2f %.2f, %.2f %.2f, %.2f %.2f%n", p0.getX(), p0.getY(), p1.getX(), p1.getY(), p2.getX(), p2.getY(), p3.getX(), p3.getY());
    }

    public void drawImage(PDImage pdImage) throws IOException {
        System.out.println("drawImage");
    }

    public void clip(int windingRule) throws IOException {
        System.out.println("clip");
    }

    public void moveTo(float x, float y) throws IOException {
        System.out.printf("moveTo %.2f %.2f%n", Float.valueOf(x), Float.valueOf(y));
    }

    public void lineTo(float x, float y) throws IOException {
        System.out.printf("lineTo %.2f %.2f%n", Float.valueOf(x), Float.valueOf(y));
    }

    public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) throws IOException {
        System.out.printf("curveTo %.2f %.2f, %.2f %.2f, %.2f %.2f%n", Float.valueOf(x1), Float.valueOf(y1), Float.valueOf(x2), Float.valueOf(y2), Float.valueOf(x3), Float.valueOf(y3));
    }

    public Point2D getCurrentPoint() throws IOException {
        return new Point2D.Float(0.0f, 0.0f);
    }

    public void closePath() throws IOException {
        System.out.println("closePath");
    }

    public void endPath() throws IOException {
        System.out.println("endPath");
    }

    public void strokePath() throws IOException {
        System.out.println("strokePath");
    }

    public void fillPath(int windingRule) throws IOException {
        System.out.println("fillPath");
    }

    public void fillAndStrokePath(int windingRule) throws IOException {
        System.out.println("fillAndStrokePath");
    }

    public void shadingFill(COSName shadingName) throws IOException {
        System.out.println("shadingFill " + shadingName.toString());
    }

    public void showTextString(byte[] string) throws IOException {
        System.out.print("showTextString \"");
        super.showTextString(string);
        System.out.println("\"");
    }

    public void showTextStrings(COSArray array) throws IOException {
        System.out.print("showTextStrings \"");
        super.showTextStrings(array);
        System.out.println("\"");
    }

    protected void showGlyph(Matrix textRenderingMatrix, PDFont font, int code, Vector displacement) throws IOException {
        System.out.print("showGlyph " + code);
        super.showGlyph(textRenderingMatrix, font, code, displacement);
    }
}

