/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.printing;

import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import javax.print.PrintServiceLookup;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.contentstream.PDFGraphicsStreamEngine;
import org.apache.pdfbox.contentstream.PDFStreamEngine;
import org.apache.pdfbox.contentstream.operator.MissingOperandException;
import org.apache.pdfbox.contentstream.operator.Operator;
import org.apache.pdfbox.contentstream.operator.OperatorProcessor;
import org.apache.pdfbox.contentstream.operator.graphics.GraphicsOperatorProcessor;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadBuffer;
import org.apache.pdfbox.pdmodel.MissingResourceException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImage;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.apache.pdfbox.printing.PDFPrintable;
import org.apache.pdfbox.printing.Scaling;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.apache.pdfbox.rendering.PageDrawer;
import org.apache.pdfbox.rendering.PageDrawerParameters;

public class OpaquePDFRenderer
extends PDFRenderer {
    public static void main(String[] args) throws IOException, PrinterException, URISyntaxException {
        try (PDDocument doc = Loader.loadPDF((RandomAccessRead)RandomAccessReadBuffer.createBufferFromStream((InputStream)new URI("https://github.com/qzind/tray/files/1749977/test.pdf").toURL().openStream()));){
            OpaquePDFRenderer renderer = new OpaquePDFRenderer(doc);
            PDFPrintable printable = new PDFPrintable(doc, Scaling.SCALE_TO_FIT, false, 0.0f, true, (PDFRenderer)renderer);
            PrinterJob job = PrinterJob.getPrinterJob();
            job.setPrintService(PrintServiceLookup.lookupDefaultPrintService());
            job.setPrintable((Printable)printable);
            if (job.printDialog()) {
                job.print();
            }
        }
    }

    public OpaquePDFRenderer(PDDocument document) {
        super(document);
    }

    protected PageDrawer createPageDrawer(PageDrawerParameters parameters) throws IOException {
        return new OpaquePageDrawer(parameters);
    }

    private static class OpaqueSetGraphicsStateParameters
    extends OperatorProcessor {
        private static final Log LOG = LogFactory.getLog(OpaqueSetGraphicsStateParameters.class);

        OpaqueSetGraphicsStateParameters(PDFStreamEngine context) {
            super(context);
        }

        public void process(Operator operator, List<COSBase> arguments) throws IOException {
            if (arguments.isEmpty()) {
                throw new MissingOperandException(operator, arguments);
            }
            COSBase base0 = arguments.get(0);
            if (!(base0 instanceof COSName)) {
                return;
            }
            COSName graphicsName = (COSName)base0;
            PDFStreamEngine context = this.getContext();
            PDExtendedGraphicsState gs = context.getResources().getExtGState(graphicsName);
            if (gs == null) {
                LOG.error((Object)("name for 'gs' operator not found in resources: /" + graphicsName.getName()));
                return;
            }
            gs.setNonStrokingAlphaConstant(Float.valueOf(1.0f));
            gs.setStrokingAlphaConstant(Float.valueOf(1.0f));
            gs.copyIntoGraphicsState(context.getGraphicsState());
        }

        public String getName() {
            return "gs";
        }
    }

    private static class OpaqueDrawObject
    extends GraphicsOperatorProcessor {
        private static final Log LOG = LogFactory.getLog(OpaqueDrawObject.class);

        OpaqueDrawObject(PDFGraphicsStreamEngine context) {
            super(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(Operator operator, List<COSBase> operands) throws IOException {
            if (operands.isEmpty()) {
                throw new MissingOperandException(operator, operands);
            }
            COSBase base0 = operands.get(0);
            if (!(base0 instanceof COSName)) {
                return;
            }
            COSName objectName = (COSName)base0;
            PDFGraphicsStreamEngine context = this.getGraphicsContext();
            PDXObject xobject = context.getResources().getXObject(objectName);
            if (xobject == null) {
                throw new MissingResourceException("Missing XObject: " + objectName.getName());
            }
            if (xobject instanceof PDImageXObject) {
                PDImageXObject image = (PDImageXObject)xobject;
                context.drawImage((PDImage)image);
            } else if (xobject instanceof PDFormXObject) {
                try {
                    context.increaseLevel();
                    if (context.getLevel() > 50) {
                        LOG.error((Object)"recursion is too deep, skipping form XObject");
                        return;
                    }
                    context.showForm((PDFormXObject)xobject);
                }
                finally {
                    context.decreaseLevel();
                }
            }
        }

        public String getName() {
            return "Do";
        }
    }

    private static class OpaquePageDrawer
    extends PageDrawer {
        OpaquePageDrawer(PageDrawerParameters parameters) throws IOException {
            super(parameters);
            this.addOperator((OperatorProcessor)new OpaqueDrawObject((PDFGraphicsStreamEngine)this));
            this.addOperator(new OpaqueSetGraphicsStateParameters((PDFStreamEngine)this));
        }
    }
}

