/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.fontbox.ttf.TrueTypeCollection;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.font.Standard14Fonts;
import org.apache.pdfbox.pdmodel.font.encoding.GlyphList;
import org.apache.pdfbox.pdmodel.font.encoding.WinAnsiEncoding;

public class EmbeddedMultipleFonts {
    private EmbeddedMultipleFonts() {
    }

    public static void main(String[] args) throws IOException {
        try (PDDocument document = new PDDocument();
             TrueTypeCollection ttc2 = new TrueTypeCollection(new File("c:/windows/fonts/batang.ttc"));
             TrueTypeCollection ttc3 = new TrueTypeCollection(new File("c:/windows/fonts/mingliu.ttc"));){
            PDPage page = new PDPage(PDRectangle.A4);
            document.addPage(page);
            PDType1Font font1 = new PDType1Font(Standard14Fonts.FontName.HELVETICA);
            PDType0Font font2 = PDType0Font.load((PDDocument)document, (TrueTypeFont)ttc2.getFontByName("Batang"), (boolean)true);
            PDType0Font font3 = PDType0Font.load((PDDocument)document, (TrueTypeFont)ttc3.getFontByName("MingLiU"), (boolean)true);
            PDType0Font font4 = PDType0Font.load((PDDocument)document, (File)new File("c:/windows/fonts/mangal.ttf"));
            PDType0Font font5 = PDType0Font.load((PDDocument)document, (File)new File("c:/windows/fonts/ArialUni.ttf"));
            try (PDPageContentStream cs = new PDPageContentStream(document, page);){
                cs.beginText();
                ArrayList<PDFont> fonts = new ArrayList<PDFont>();
                fonts.add((PDFont)font1);
                fonts.add((PDFont)font2);
                fonts.add((PDFont)font3);
                fonts.add((PDFont)font4);
                fonts.add((PDFont)font5);
                cs.newLineAtOffset(20.0f, 700.0f);
                EmbeddedMultipleFonts.showTextMultiple(cs, "abc \ud55c\uad6d \u4e2d\u56fd \u092d\u093e\u0930\u0924 \u65e5\u672c abc", fonts, 20.0f);
                cs.endText();
            }
            document.save("example.pdf");
        }
    }

    static void showTextMultiple(PDPageContentStream cs, String text, List<PDFont> fonts, float size) throws IOException {
        try {
            fonts.get(0).encode(text);
            cs.setFont(fonts.get(0), size);
            cs.showText(text);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            int i = 0;
            while (i < text.length()) {
                boolean found = false;
                for (PDFont font : fonts) {
                    try {
                        String s2;
                        int j;
                        String s = text.substring(i, i + 1);
                        font.encode(s);
                        for (j = i + 1; !(j >= text.length() || EmbeddedMultipleFonts.isWinAnsiEncoding((s2 = text.substring(j, j + 1)).codePointAt(0)) && font != fonts.get(0)); ++j) {
                            try {
                                font.encode(s2);
                                continue;
                            }
                            catch (IllegalArgumentException ex) {
                                break;
                            }
                        }
                        s = text.substring(i, j);
                        cs.setFont(font, size);
                        cs.showText(s);
                        i = j;
                        found = true;
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException2) {
                    }
                }
                if (found) continue;
                throw new IllegalArgumentException("Could not show '" + text.substring(i, i + 1) + "' with the fonts provided");
            }
            return;
        }
    }

    static boolean isWinAnsiEncoding(int unicode) {
        String name = GlyphList.getAdobeGlyphList().codePointToName(unicode);
        if (".notdef".equals(name)) {
            return false;
        }
        return WinAnsiEncoding.INSTANCE.contains(name);
    }
}

