/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;

public class PrintTextLocations
extends PDFTextStripper {
    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            PrintTextLocations.usage();
        } else {
            try (PDDocument document = Loader.loadPDF((File)new File(args[0]));){
                PrintTextLocations stripper = new PrintTextLocations();
                stripper.setSortByPosition(true);
                stripper.setStartPage(1);
                stripper.setEndPage(document.getNumberOfPages());
                OutputStreamWriter dummy = new OutputStreamWriter(new ByteArrayOutputStream());
                stripper.writeText(document, dummy);
            }
        }
    }

    protected void writeString(String string, List<TextPosition> textPositions) throws IOException {
        for (TextPosition text : textPositions) {
            System.out.println("String[" + text.getXDirAdj() + "," + text.getYDirAdj() + " font=" + text.getFont().getName() + ":" + text.getFontSize() + " xscale=" + text.getXScale() + " height=" + text.getHeightDir() + " space=" + text.getWidthOfSpace() + " width=" + text.getWidthDirAdj() + "]" + text.getUnicode());
        }
    }

    private static void usage() {
        System.err.println("Usage: java " + PrintTextLocations.class.getName() + " <input-pdf>");
    }
}

