/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.signature;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.examples.signature.SigUtils;
import org.apache.pdfbox.examples.signature.ValidationTimeStamp;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSignature;
import org.apache.pdfbox.pdmodel.interactive.digitalsignature.SignatureInterface;

public class CreateSignedTimeStamp
implements SignatureInterface {
    private static final Log LOG = LogFactory.getLog(CreateSignedTimeStamp.class);
    private final String tsaUrl;

    public CreateSignedTimeStamp(String tsaUrl) {
        this.tsaUrl = tsaUrl;
    }

    public void signDetached(File file) throws IOException {
        this.signDetached(file, file);
    }

    public void signDetached(File inFile, File outFile) throws IOException {
        if (inFile == null || !inFile.exists()) {
            throw new FileNotFoundException("Document for signing does not exist");
        }
        try (PDDocument doc = Loader.loadPDF((File)inFile);
             FileOutputStream fos = new FileOutputStream(outFile);){
            this.signDetached(doc, fos);
        }
    }

    public void signDetached(PDDocument document, OutputStream output) throws IOException {
        int accessPermissions = SigUtils.getMDPPermission(document);
        if (accessPermissions == 1) {
            throw new IllegalStateException("No changes to the document are permitted due to DocMDP transform parameters dictionary");
        }
        PDSignature signature = new PDSignature();
        signature.setType(COSName.DOC_TIME_STAMP);
        signature.setFilter(PDSignature.FILTER_ADOBE_PPKLITE);
        signature.setSubFilter(COSName.getPDFName((String)"ETSI.RFC3161"));
        document.addSignature(signature, (SignatureInterface)this);
        document.saveIncremental(output);
    }

    public byte[] sign(InputStream content) throws IOException {
        try {
            ValidationTimeStamp validation = new ValidationTimeStamp(this.tsaUrl);
            return validation.getTimeStampToken(content);
        }
        catch (URISyntaxException | NoSuchAlgorithmException e) {
            LOG.error((Object)"Hashing-Algorithm not found for TimeStamping", (Throwable)e);
            return new byte[0];
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            CreateSignedTimeStamp.usage();
            System.exit(1);
        }
        String tsaUrl = null;
        if ("-tsa".equals(args[1])) {
            tsaUrl = args[2];
        } else {
            CreateSignedTimeStamp.usage();
            System.exit(1);
        }
        CreateSignedTimeStamp signing = new CreateSignedTimeStamp(tsaUrl);
        File inFile = new File(args[0]);
        String name = inFile.getName();
        String substring = name.substring(0, name.lastIndexOf(46));
        File outFile = new File(inFile.getParent(), substring + "_timestamped.pdf");
        signing.signDetached(inFile, outFile);
    }

    private static void usage() {
        System.err.println("usage: java " + CreateSignedTimeStamp.class.getName() + " <pdf_to_sign>\nmandatory options:\n  -tsa <url>    sign timestamp using the given TSA server\n");
    }
}

