/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationRubberStamp;

public final class RubberStamp {
    private RubberStamp() {
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            RubberStamp.usage();
        } else {
            try (PDDocument document = Loader.loadPDF((File)new File(args[0]));){
                if (document.isEncrypted()) {
                    throw new IOException("Encrypted documents are not supported for this example");
                }
                for (PDPage page : document.getPages()) {
                    List annotations = page.getAnnotations();
                    PDAnnotationRubberStamp rs = new PDAnnotationRubberStamp();
                    rs.setName("TopSecret");
                    rs.setRectangle(new PDRectangle(100.0f, 100.0f));
                    rs.setContents("A top secret note");
                    annotations.add(rs);
                }
                document.save(args[1]);
            }
        }
    }

    private static void usage() {
        System.err.println("Usage: java " + RubberStamp.class.getName() + " <input-pdf> <output-pdf>");
    }
}

