/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionURI;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.text.PDFTextStripperByArea;

public final class PrintURLs {
    private PrintURLs() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        try (PDDocument doc = null;){
            if (args.length != 1) {
                PrintURLs.usage();
            } else {
                doc = Loader.loadPDF((File)new File(args[0]));
                int pageNum = 0;
                for (PDPage page : doc.getPages()) {
                    PDAnnotation annot;
                    int j;
                    ++pageNum;
                    PDFTextStripperByArea stripper = new PDFTextStripperByArea();
                    List annotations = page.getAnnotations();
                    for (j = 0; j < annotations.size(); ++j) {
                        annot = (PDAnnotation)annotations.get(j);
                        if (PrintURLs.getActionURI(annot) == null) continue;
                        PDRectangle rect = annot.getRectangle();
                        float x = rect.getLowerLeftX();
                        float y = rect.getUpperRightY();
                        float width = rect.getWidth();
                        float height = rect.getHeight();
                        int rotation = page.getRotation();
                        if (rotation == 0) {
                            PDRectangle pageSize = page.getMediaBox();
                            y = pageSize.getHeight() - y;
                        }
                        Rectangle2D.Float awtRect = new Rectangle2D.Float(x, y, width, height);
                        stripper.addRegion("" + j, (Rectangle2D)awtRect);
                    }
                    stripper.extractRegions(page);
                    for (j = 0; j < annotations.size(); ++j) {
                        annot = (PDAnnotation)annotations.get(j);
                        PDActionURI uri = PrintURLs.getActionURI(annot);
                        if (uri == null) continue;
                        String urlText = stripper.getTextForRegion("" + j);
                        System.out.println("Page " + pageNum + ":'" + urlText.trim() + "'=" + uri.getURI());
                    }
                }
            }
        }
    }

    private static PDActionURI getActionURI(PDAnnotation annot) {
        try {
            PDAction action;
            Method actionMethod = annot.getClass().getDeclaredMethod("getAction", new Class[0]);
            if (actionMethod.getReturnType().equals(PDAction.class) && (action = (PDAction)actionMethod.invoke((Object)annot, new Object[0])) instanceof PDActionURI) {
                return (PDActionURI)action;
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }

    private static void usage() {
        System.err.println("usage: " + PrintURLs.class.getName() + " <input-file>");
    }
}

