/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.io.IOException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.function.PDFunctionType2;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDSeparation;

public class CreateSeparationColorBox {
    private CreateSeparationColorBox() {
    }

    public static void main(String[] args) throws IOException {
        try (PDDocument doc = new PDDocument();){
            PDPage page = new PDPage();
            doc.addPage(page);
            COSArray separationArray = new COSArray();
            separationArray.add((COSBase)COSName.SEPARATION);
            separationArray.add((COSBase)COSName.getPDFName((String)"Gold"));
            separationArray.add((COSBase)COSName.DEVICERGB);
            COSDictionary fdict = new COSDictionary();
            fdict.setInt(COSName.FUNCTION_TYPE, 2);
            COSArray range = new COSArray();
            range.add((COSBase)COSInteger.ZERO);
            range.add((COSBase)COSInteger.ONE);
            range.add((COSBase)COSInteger.ZERO);
            range.add((COSBase)COSInteger.ONE);
            range.add((COSBase)COSInteger.ZERO);
            range.add((COSBase)COSInteger.ONE);
            fdict.setItem(COSName.RANGE, (COSBase)range);
            COSArray domain = new COSArray();
            domain.add((COSBase)COSInteger.ZERO);
            domain.add((COSBase)COSInteger.ONE);
            fdict.setItem(COSName.DOMAIN, (COSBase)domain);
            COSArray c0 = new COSArray();
            c0.add((COSBase)COSInteger.ONE);
            c0.add((COSBase)COSInteger.ONE);
            c0.add((COSBase)COSInteger.ONE);
            fdict.setItem(COSName.C0, (COSBase)c0);
            COSArray c1 = new COSArray();
            c1.add((COSBase)COSInteger.ONE);
            c1.add((COSBase)COSInteger.ONE);
            c1.add((COSBase)COSInteger.ZERO);
            fdict.setItem(COSName.C1, (COSBase)c1);
            fdict.setInt(COSName.N, 1);
            PDFunctionType2 func = new PDFunctionType2((COSBase)fdict);
            separationArray.add((COSObjectable)func);
            PDSeparation spotColorSpace = new PDSeparation(separationArray, null);
            try (PDPageContentStream cs = new PDPageContentStream(doc, page);){
                PDColor color = new PDColor(new float[]{0.5f}, (PDColorSpace)spotColorSpace);
                cs.setStrokingColor(color);
                cs.setLineWidth(10.0f);
                cs.addRect(50.0f, 50.0f, 500.0f, 700.0f);
                cs.stroke();
            }
            doc.save("gold.pdf");
        }
    }
}

