/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.interactive.form;

import java.awt.image.BufferedImage;
import java.io.IOException;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.pdmodel.PDAppearanceContentStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionJavaScript;
import org.apache.pdfbox.pdmodel.interactive.action.PDAnnotationAdditionalActions;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAppearanceStream;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDPushButton;

public class CreatePushButton {
    public static void main(String[] args) throws IOException {
        try (PDDocument doc = new PDDocument();){
            PDPage page = new PDPage();
            doc.addPage(page);
            PDAcroForm acroForm = new PDAcroForm(doc);
            doc.getDocumentCatalog().setAcroForm(acroForm);
            PDPushButton pushButton = new PDPushButton(acroForm);
            pushButton.setPartialName("push");
            acroForm.getFields().add(pushButton);
            PDAnnotationWidget widget = (PDAnnotationWidget)pushButton.getWidgets().get(0);
            page.getAnnotations().add(widget);
            widget.setRectangle(new PDRectangle(50.0f, 500.0f, 100.0f, 100.0f));
            widget.setPrinted(true);
            widget.setPage(page);
            PDActionJavaScript javascriptAction = new PDActionJavaScript("app.alert(\"button pressed\")");
            PDAnnotationAdditionalActions actions = new PDAnnotationAdditionalActions();
            actions.setU((PDAction)javascriptAction);
            widget.setActions(actions);
            PDFormXObject form = new PDFormXObject(doc);
            form.setResources(new PDResources());
            form.setBBox(new PDRectangle(100.0f, 100.0f));
            form.setFormType(1);
            PDAppearanceDictionary appearanceDictionary = new PDAppearanceDictionary(new COSDictionary());
            widget.setAppearance(appearanceDictionary);
            PDAppearanceStream appearanceStream = new PDAppearanceStream(form.getCOSObject());
            appearanceDictionary.setNormalAppearance(appearanceStream);
            BufferedImage bim = new BufferedImage(100, 100, 1);
            PDImageXObject image = LosslessFactory.createFromImage((PDDocument)doc, (BufferedImage)bim);
            try (PDAppearanceContentStream cs = new PDAppearanceContentStream(appearanceStream);){
                cs.drawImage(image, 0.0f, 0.0f);
            }
            doc.save("target/PushButtonSample.pdf");
        }
    }
}

