/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.util.HashMap;
import java.util.Map;
import org.apache.fontbox.cff.CFFCharset;

class CFFCharsetCID
implements CFFCharset {
    private static final String EXCEPTION_MESSAGE = "Not a Type 1-equivalent font";
    private final Map<Integer, Integer> sidOrCidToGid = new HashMap<Integer, Integer>(250);
    private final Map<Integer, Integer> gidToCid = new HashMap<Integer, Integer>();

    CFFCharsetCID() {
    }

    @Override
    public boolean isCIDFont() {
        return true;
    }

    @Override
    public void addSID(int gid, int sid, String name) {
        throw new IllegalStateException(EXCEPTION_MESSAGE);
    }

    @Override
    public void addCID(int gid, int cid) {
        this.sidOrCidToGid.put(cid, gid);
        this.gidToCid.put(gid, cid);
    }

    @Override
    public int getSIDForGID(int sid) {
        throw new IllegalStateException(EXCEPTION_MESSAGE);
    }

    @Override
    public int getGIDForSID(int sid) {
        throw new IllegalStateException(EXCEPTION_MESSAGE);
    }

    @Override
    public int getGIDForCID(int cid) {
        Integer gid = this.sidOrCidToGid.get(cid);
        if (gid == null) {
            return 0;
        }
        return gid;
    }

    @Override
    public int getSID(String name) {
        throw new IllegalStateException(EXCEPTION_MESSAGE);
    }

    @Override
    public String getNameForGID(int gid) {
        throw new IllegalStateException(EXCEPTION_MESSAGE);
    }

    @Override
    public int getCIDForGID(int gid) {
        Integer cid = this.gidToCid.get(gid);
        if (cid != null) {
            return cid;
        }
        return 0;
    }
}

