/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util.awt;

import android.graphics.Matrix;
import android.graphics.PointF;

public class AffineTransform {
    private double m00;
    private double m10;
    private double m01;
    private double m11;
    private double m02;
    private double m12;

    public AffineTransform() {
        this.m11 = 1.0;
        this.m00 = 1.0;
    }

    public AffineTransform(AffineTransform tx) {
        this.setTransform(tx);
    }

    public AffineTransform(double m00, double m10, double m01, double m11, double m02, double m12) {
        this.m00 = m00;
        this.m10 = m10;
        this.m01 = m01;
        this.m11 = m11;
        this.m02 = m02;
        this.m12 = m12;
    }

    public AffineTransform(double[] d) {
        this.m00 = d[0];
        this.m10 = d[1];
        this.m01 = d[2];
        this.m11 = d[3];
        if (d.length >= 6) {
            this.m02 = d[4];
            this.m12 = d[5];
        }
    }

    public AffineTransform(Matrix matrix) {
        float[] values = new float[9];
        matrix.getValues(values);
        this.m00 = values[0];
        this.m01 = values[1];
        this.m02 = values[2];
        this.m10 = values[3];
        this.m11 = values[4];
        this.m12 = values[5];
    }

    public static AffineTransform getTranslateInstance(double tx, double ty) {
        AffineTransform t = new AffineTransform();
        t.m02 = tx;
        t.m12 = ty;
        return t;
    }

    public static AffineTransform getScaleInstance(double sx, double sy) {
        AffineTransform t = new AffineTransform();
        t.setToScale(sx, sy);
        return t;
    }

    public void setTransform(AffineTransform tx) {
        this.m00 = tx.m00;
        this.m01 = tx.m01;
        this.m02 = tx.m02;
        this.m10 = tx.m10;
        this.m11 = tx.m11;
        this.m12 = tx.m12;
    }

    public double getScaleX() {
        return this.m00;
    }

    public double getShearY() {
        return this.m10;
    }

    public double getShearX() {
        return this.m01;
    }

    public double getScaleY() {
        return this.m11;
    }

    public double getTranslateX() {
        return this.m02;
    }

    public double getTranslateY() {
        return this.m12;
    }

    public void getMatrix(double[] values) {
        values[0] = this.m00;
        values[1] = this.m10;
        values[2] = this.m01;
        values[3] = this.m11;
        values[4] = this.m02;
        values[5] = this.m12;
    }

    public PointF transform(PointF src, PointF dst) {
        if (dst == null) {
            dst = new PointF();
        }
        double x = src.x;
        double y = src.y;
        double nx = this.m00 * x + this.m01 * y + this.m02;
        double ny = this.m10 * x + this.m11 * y + this.m12;
        dst.set((float)nx, (float)ny);
        return dst;
    }

    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int num) {
        if (srcPts == dstPts && dstOff > srcOff && num > 1 && srcOff + 2 * num > dstOff) {
            double[] d = new double[2 * num];
            System.arraycopy(srcPts, srcOff, d, 0, 2 * num);
            srcPts = d;
        }
        while (--num >= 0) {
            double x = srcPts[srcOff++];
            double y = srcPts[srcOff++];
            dstPts[dstOff++] = this.m00 * x + this.m01 * y + this.m02;
            dstPts[dstOff++] = this.m10 * x + this.m11 * y + this.m12;
        }
    }

    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int num) {
        if (srcPts == dstPts && dstOff > srcOff && num > 1 && srcOff + 2 * num > dstOff) {
            float[] f = new float[2 * num];
            System.arraycopy(srcPts, srcOff, f, 0, 2 * num);
            srcPts = f;
        }
        while (--num >= 0) {
            float x = srcPts[srcOff++];
            float y = srcPts[srcOff++];
            dstPts[dstOff++] = (float)(this.m00 * (double)x + this.m01 * (double)y + this.m02);
            dstPts[dstOff++] = (float)(this.m10 * (double)x + this.m11 * (double)y + this.m12);
        }
    }

    public void scale(double sx, double sy) {
        this.m00 *= sx;
        this.m01 *= sy;
        this.m10 *= sx;
        this.m11 *= sy;
    }

    public void translate(double tx, double ty) {
        this.m02 += tx * this.m00 + ty * this.m01;
        this.m12 += tx * this.m10 + ty * this.m11;
    }

    public float[] transform(float[] src, float[] dst) {
        if (dst == null) {
            dst = new float[2];
        }
        float x = src[0];
        float y = src[1];
        float nx = (float)(this.m00 * (double)x + this.m01 * (double)y + this.m02);
        float ny = (float)(this.m10 * (double)x + this.m11 * (double)y + this.m12);
        dst[0] = nx;
        dst[1] = ny;
        return dst;
    }

    public void rotate(double theta) {
        double c = Math.cos(theta);
        double s = Math.sin(theta);
        double n00 = this.m00 * c + this.m01 * s;
        double n01 = this.m00 * -s + this.m01 * c;
        double n10 = this.m10 * c + this.m11 * s;
        double n11 = this.m10 * -s + this.m11 * c;
        this.m00 = n00;
        this.m01 = n01;
        this.m10 = n10;
        this.m11 = n11;
    }

    public void setToScale(double sx, double sy) {
        this.m00 = sx;
        this.m12 = 0.0;
        this.m10 = 0.0;
        this.m02 = 0.0;
        this.m01 = 0.0;
        this.m11 = sy;
    }

    public boolean isIdentity() {
        return this.m00 == 1.0 && this.m01 == 0.0 && this.m02 == 0.0 && this.m10 == 0.0 && this.m11 == 1.0 && this.m12 == 0.0;
    }

    public Matrix toMatrix() {
        Matrix retval = new Matrix();
        retval.setValues(new float[]{(float)this.m00, (float)this.m01, (float)this.m02, (float)this.m10, (float)this.m11, (float)this.m12, 0.0f, 0.0f, 1.0f});
        return retval;
    }
}

