/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.text;

import android.graphics.RectF;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;

public class PDFTextStripperByArea
extends PDFTextStripper {
    private final List<String> regions = new ArrayList<String>();
    private final Map<String, RectF> regionArea = new HashMap<String, RectF>();
    private final Map<String, Vector<List<TextPosition>>> regionCharacterList = new HashMap<String, Vector<List<TextPosition>>>();
    private final Map<String, StringWriter> regionText = new HashMap<String, StringWriter>();

    public void addRegion(String regionName, RectF rect) {
        this.regions.add(regionName);
        this.regionArea.put(regionName, rect);
    }

    public List<String> getRegions() {
        return this.regions;
    }

    public String getTextForRegion(String regionName) {
        StringWriter text = this.regionText.get(regionName);
        return text.toString();
    }

    public void extractRegions(PDPage page) throws IOException {
        Iterator<String> regionIter = this.regions.iterator();
        while (regionIter.hasNext()) {
            this.setStartPage(this.getCurrentPageNo());
            this.setEndPage(this.getCurrentPageNo());
            String regionName = regionIter.next();
            Vector regionCharactersByArticle = new Vector();
            regionCharactersByArticle.add(new ArrayList());
            this.regionCharacterList.put(regionName, regionCharactersByArticle);
            this.regionText.put(regionName, new StringWriter());
        }
        PDStream contentStream = page.getStream();
        if (contentStream != null) {
            this.processPage(page);
        }
    }

    @Override
    protected void processTextPosition(TextPosition text) {
        for (String region : this.regionArea.keySet()) {
            RectF rect = this.regionArea.get(region);
            if (!rect.contains(text.getX(), text.getY())) continue;
            this.charactersByArticle = this.regionCharacterList.get(region);
            super.processTextPosition(text);
        }
    }

    @Override
    protected void writePage() throws IOException {
        for (String region : this.regionArea.keySet()) {
            this.charactersByArticle = this.regionCharacterList.get(region);
            this.output = this.regionText.get(region);
            super.writePage();
        }
    }
}

