/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.form;

import java.io.IOException;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.common.PDTextStream;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDFieldTreeNode;
import org.apache.pdfbox.pdmodel.interactive.form.PDVariableText;

public final class PDTextField
extends PDVariableText {
    private static final int FLAG_MULTILINE = 4096;
    private static final int FLAG_PASSWORD = 8192;
    private static final int FLAG_FILE_SELECT = 0x100000;
    private static final int FLAG_DO_NOT_SPELL_CHECK = 0x400000;
    private static final int FLAG_DO_NOT_SCROLL = 0x800000;
    private static final int FLAG_COMB = 0x1000000;
    private static final int FLAG_RICH_TEXT = 0x2000000;

    public PDTextField(PDAcroForm theAcroForm) {
        super(theAcroForm);
        this.getDictionary().setItem(COSName.FT, (COSBase)COSName.TX);
    }

    public PDTextField(PDAcroForm theAcroForm, COSDictionary field, PDFieldTreeNode parentNode) {
        super(theAcroForm, field, parentNode);
    }

    public boolean isMultiline() {
        return this.getDictionary().getFlag(COSName.FF, 4096);
    }

    public void setMultiline(boolean multiline) {
        this.getDictionary().setFlag(COSName.FF, 4096, multiline);
    }

    public boolean isPassword() {
        return this.getDictionary().getFlag(COSName.FF, 8192);
    }

    public void setPassword(boolean password) {
        this.getDictionary().setFlag(COSName.FF, 8192, password);
    }

    public boolean isFileSelect() {
        return this.getDictionary().getFlag(COSName.FF, 0x100000);
    }

    public void setFileSelect(boolean fileSelect) {
        this.getDictionary().setFlag(COSName.FF, 0x100000, fileSelect);
    }

    public boolean doNotSpellCheck() {
        return this.getDictionary().getFlag(COSName.FF, 0x400000);
    }

    public void setDoNotSpellCheck(boolean doNotSpellCheck) {
        this.getDictionary().setFlag(COSName.FF, 0x400000, doNotSpellCheck);
    }

    public boolean doNotScroll() {
        return this.getDictionary().getFlag(COSName.FF, 0x800000);
    }

    public void setDoNotScroll(boolean doNotScroll) {
        this.getDictionary().setFlag(COSName.FF, 0x800000, doNotScroll);
    }

    public boolean isComb() {
        return this.getDictionary().getFlag(COSName.FF, 0x1000000);
    }

    public void setComb(boolean comb) {
        this.getDictionary().setFlag(COSName.FF, 0x1000000, comb);
    }

    public boolean isRichText() {
        return this.getDictionary().getFlag(COSName.FF, 0x2000000);
    }

    public void setRichText(boolean richText) {
        this.getDictionary().setFlag(COSName.FF, 0x2000000, richText);
    }

    public int getMaxLen() {
        return this.getDictionary().getInt(COSName.MAX_LEN);
    }

    public void setMaxLen(int maxLen) {
        this.getDictionary().setInt(COSName.MAX_LEN, maxLen);
    }

    @Override
    public void setDefaultValue(String value) {
        if (value != null) {
            COSString fieldValue = new COSString(value);
            this.setInheritableAttribute(COSName.DV, fieldValue);
        } else {
            this.removeInheritableAttribute(COSName.DV);
        }
    }

    @Override
    public String getDefaultValue() {
        COSBase fieldValue = this.getInheritableAttribute(COSName.DV);
        if (fieldValue instanceof COSString) {
            return ((COSString)fieldValue).getString();
        }
        return "";
    }

    @Override
    public void setValue(String value) throws IOException {
        if (value != null && !value.isEmpty()) {
            COSString fieldValue = new COSString(value);
            this.setInheritableAttribute(COSName.V, fieldValue);
        } else {
            this.removeInheritableAttribute(COSName.DV);
        }
        this.updateFieldAppearances();
    }

    public void setValue(PDTextStream textStream) throws IOException {
        if (textStream != null) {
            this.setInheritableAttribute(COSName.V, textStream.getCOSObject());
        } else {
            this.removeInheritableAttribute(COSName.V);
        }
        this.updateFieldAppearances();
    }

    @Override
    public String getValue() throws IOException {
        PDTextStream textStream = this.getAsTextStream(this.getInheritableAttribute(COSName.V));
        if (textStream != null) {
            return textStream.getAsString();
        }
        return "";
    }

    public PDTextStream getValueAsStream() throws IOException {
        return this.getAsTextStream(this.getInheritableAttribute(COSName.V));
    }
}

