/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.form;

import java.io.IOException;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDButton;
import org.apache.pdfbox.pdmodel.interactive.form.PDFieldTreeNode;

public final class PDCheckbox
extends PDButton {
    public PDCheckbox(PDAcroForm theAcroForm) {
        super(theAcroForm);
    }

    public PDCheckbox(PDAcroForm theAcroForm, COSDictionary field, PDFieldTreeNode parentNode) {
        super(theAcroForm, field, parentNode);
    }

    public boolean isChecked() throws IOException {
        String onValue = this.getOnValue();
        String fieldValue = null;
        try {
            fieldValue = this.getValue();
        }
        catch (IOException e) {
            return false;
        }
        COSName radioValue = (COSName)this.getDictionary().getDictionaryObject(COSName.AS);
        return radioValue != null && fieldValue != null && radioValue.getName().equals(onValue);
    }

    public void check() {
        String onValue = this.getOnValue();
        this.setValue(onValue);
        this.getDictionary().setItem(COSName.AS, (COSBase)COSName.getPDFName(onValue));
    }

    public void unCheck() {
        this.getDictionary().setItem(COSName.AS, (COSBase)PDButton.OFF);
    }

    public String getOffValue() {
        return PDButton.OFF.getName();
    }

    public String getOnValue() {
        COSDictionary ap = (COSDictionary)this.getDictionary().getDictionaryObject(COSName.AP);
        COSBase n = ap.getDictionaryObject(COSName.N);
        if (n instanceof COSDictionary) {
            for (COSName key : ((COSDictionary)n).keySet()) {
                if (key.equals(PDButton.OFF)) continue;
                return key.getName();
            }
        }
        return "";
    }

    @Override
    public String getValue() throws IOException {
        COSBase attribute = this.getInheritableAttribute(COSName.V);
        if (attribute == null) {
            return "";
        }
        if (attribute instanceof COSName) {
            return ((COSName)attribute).getName();
        }
        throw new IOException("Expected a COSName entry but got " + attribute.getClass().getName());
    }

    @Override
    public void setValue(String value) {
        if (value == null) {
            this.getDictionary().removeItem(COSName.V);
            this.getDictionary().setItem(COSName.AS, (COSBase)PDButton.OFF);
        } else {
            COSName nameValue = COSName.getPDFName(value);
            this.getDictionary().setItem(COSName.V, (COSBase)nameValue);
            this.getDictionary().setItem(COSName.AS, (COSBase)nameValue);
        }
    }
}

