/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.image;

import android.graphics.Bitmap;
import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.filter.DecodeResult;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.image.PDImage;
import org.apache.pdfbox.pdmodel.graphics.image.SampledImageReader;

public final class PDImageXObject
extends PDXObject
implements PDImage {
    private Bitmap cachedImage;
    private PDColorSpace colorSpace;
    private PDResources resources;

    public static PDImageXObject createThumbnail(COSStream cosStream) throws IOException {
        PDStream pdStream = new PDStream(cosStream);
        return new PDImageXObject(pdStream, null);
    }

    public PDImageXObject(PDDocument document) throws IOException {
        this(new PDStream(document), (PDResources)null);
    }

    public PDImageXObject(PDDocument document, InputStream filteredStream, COSBase cosFilter, int width, int height, int bitsPerComponent, PDColorSpace initColorSpace) throws IOException {
        super(new PDStream(document, filteredStream, true), COSName.IMAGE);
        this.getCOSStream().setItem(COSName.FILTER, cosFilter);
        this.resources = null;
        this.colorSpace = null;
        this.setBitsPerComponent(bitsPerComponent);
        this.setWidth(width);
        this.setHeight(height);
        this.setColorSpace(initColorSpace);
    }

    public PDImageXObject(PDStream stream, PDResources resources) throws IOException {
        this(stream, resources, stream.getStream().getDecodeResult());
    }

    private PDImageXObject(PDStream stream, PDResources resources, DecodeResult decodeResult) {
        super(PDImageXObject.repair(stream, decodeResult), COSName.IMAGE);
        this.resources = resources;
    }

    private static PDStream repair(PDStream stream, DecodeResult decodeResult) {
        stream.getStream().addAll(decodeResult.getParameters());
        return stream;
    }

    public PDMetadata getMetadata() {
        COSStream cosStream = (COSStream)this.getCOSStream().getDictionaryObject(COSName.METADATA);
        if (cosStream != null) {
            return new PDMetadata(cosStream);
        }
        return null;
    }

    public void setMetadata(PDMetadata meta) {
        this.getCOSStream().setItem(COSName.METADATA, (COSObjectable)meta);
    }

    public int getStructParent() {
        return this.getCOSStream().getInt(COSName.STRUCT_PARENT, 0);
    }

    public void setStructParent(int key) {
        this.getCOSStream().setInt(COSName.STRUCT_PARENT, key);
    }

    @Override
    public Bitmap getImage() throws IOException {
        PDImageXObject mask;
        if (this.cachedImage != null) {
            return this.cachedImage;
        }
        Bitmap image = SampledImageReader.getRGBImage(this, this.getColorKeyMask());
        PDImageXObject softMask = this.getSoftMask();
        if (softMask != null || (mask = this.getMask()) != null) {
            // empty if block
        }
        this.cachedImage = image;
        return image;
    }

    public Bitmap getOpaqueImage() throws IOException {
        return SampledImageReader.getRGBImage(this, null);
    }

    private Bitmap applyMask(Bitmap image, Bitmap mask, boolean isSoft) throws IOException {
        if (mask == null) {
            return image;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        float[] rgb = new float[4];
        float[] rgba = new float[4];
        Object alphaPixel = null;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                rgba[0] = rgb[0];
                rgba[1] = rgb[1];
                rgba[2] = rgb[2];
                rgba[3] = isSoft ? alphaPixel[0] : 255.0f - alphaPixel[0];
            }
        }
        return null;
    }

    public PDImageXObject getMask() throws IOException {
        COSBase mask = this.getCOSStream().getDictionaryObject(COSName.MASK);
        if (mask instanceof COSArray) {
            return null;
        }
        COSStream cosStream = (COSStream)this.getCOSStream().getDictionaryObject(COSName.MASK);
        if (cosStream != null) {
            return new PDImageXObject(new PDStream(cosStream), null);
        }
        return null;
    }

    public COSArray getColorKeyMask() {
        COSBase mask = this.getCOSStream().getDictionaryObject(COSName.MASK);
        if (mask instanceof COSArray) {
            return (COSArray)mask;
        }
        return null;
    }

    public PDImageXObject getSoftMask() throws IOException {
        COSStream cosStream = (COSStream)this.getCOSStream().getDictionaryObject(COSName.SMASK);
        if (cosStream != null) {
            return new PDImageXObject(new PDStream(cosStream), null);
        }
        return null;
    }

    @Override
    public int getBitsPerComponent() {
        if (this.isStencil()) {
            return 1;
        }
        Log.d((String)"PdfBoxAndroid", (String)(this.getCOSStream().getInt(COSName.BITS_PER_COMPONENT, COSName.BPC) + ""));
        return this.getCOSStream().getInt(COSName.BITS_PER_COMPONENT, COSName.BPC);
    }

    @Override
    public void setBitsPerComponent(int bpc) {
        this.getCOSStream().setInt(COSName.BITS_PER_COMPONENT, bpc);
    }

    @Override
    public PDColorSpace getColorSpace() throws IOException {
        if (this.colorSpace == null) {
            COSBase cosBase = this.getCOSStream().getDictionaryObject(COSName.COLORSPACE, COSName.CS);
            if (cosBase != null) {
                this.colorSpace = PDColorSpace.create(cosBase, this.resources);
            } else {
                if (this.isStencil()) {
                    return PDDeviceGray.INSTANCE;
                }
                throw new IOException("could not determine color space");
            }
        }
        return this.colorSpace;
    }

    @Override
    public PDStream getStream() throws IOException {
        return this.getPDStream();
    }

    @Override
    public void setColorSpace(PDColorSpace cs) {
        this.getCOSStream().setItem(COSName.COLORSPACE, cs != null ? cs.getCOSObject() : null);
        this.getCOSStream().setItem(COSName.COLORSPACE, (COSBase)COSName.DEVICERGB);
    }

    @Override
    public int getHeight() {
        return this.getCOSStream().getInt(COSName.HEIGHT);
    }

    @Override
    public void setHeight(int h) {
        this.getCOSStream().setInt(COSName.HEIGHT, h);
    }

    @Override
    public int getWidth() {
        return this.getCOSStream().getInt(COSName.WIDTH);
    }

    @Override
    public void setWidth(int w) {
        this.getCOSStream().setInt(COSName.WIDTH, w);
    }

    @Override
    public boolean getInterpolate() {
        return this.getCOSStream().getBoolean(COSName.INTERPOLATE, false);
    }

    @Override
    public void setInterpolate(boolean value) {
        this.getCOSStream().setBoolean(COSName.INTERPOLATE, value);
    }

    @Override
    public void setDecode(COSArray decode) {
        this.getCOSStream().setItem(COSName.DECODE, (COSBase)decode);
    }

    @Override
    public COSArray getDecode() {
        COSBase decode = this.getCOSStream().getDictionaryObject(COSName.DECODE);
        if (decode instanceof COSArray) {
            return (COSArray)decode;
        }
        return null;
    }

    @Override
    public boolean isStencil() {
        return this.getCOSStream().getBoolean(COSName.IMAGE_MASK, false);
    }

    @Override
    public void setStencil(boolean isStencil) {
        this.getCOSStream().setBoolean(COSName.IMAGE_MASK, isStencil);
    }

    @Override
    public String getSuffix() {
        List<COSName> filters = this.getPDStream().getFilters();
        if (filters == null) {
            return "png";
        }
        if (filters.contains(COSName.DCT_DECODE)) {
            return "jpg";
        }
        if (filters.contains(COSName.JPX_DECODE)) {
            return "jpx";
        }
        if (filters.contains(COSName.CCITTFAX_DECODE)) {
            return "tiff";
        }
        if (filters.contains(COSName.FLATE_DECODE) || filters.contains(COSName.LZW_DECODE) || filters.contains(COSName.RUN_LENGTH_DECODE)) {
            return "png";
        }
        Log.w((String)"PdfBoxAndroid", (String)("getSuffix() returns null, filters: " + filters));
        return null;
    }
}

