/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.color;

import java.io.IOException;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.pdmodel.MissingResourceException;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;

public abstract class PDColorSpace
implements COSObjectable {
    protected COSArray array;

    public static PDColorSpace create(COSBase colorSpace) throws IOException {
        return PDColorSpace.create(colorSpace, null);
    }

    public static PDColorSpace create(COSBase colorSpace, PDResources resources) throws IOException {
        if (colorSpace instanceof COSObject) {
            return PDColorSpace.create(((COSObject)colorSpace).getObject(), resources);
        }
        if (colorSpace instanceof COSName) {
            COSName name = (COSName)colorSpace;
            if (resources != null) {
                COSName defaultName = null;
                if (name.equals(COSName.DEVICECMYK) && resources.hasColorSpace(COSName.DEFAULT_CMYK)) {
                    defaultName = COSName.DEFAULT_CMYK;
                } else if (name.equals(COSName.DEVICERGB) && resources.hasColorSpace(COSName.DEFAULT_RGB)) {
                    defaultName = COSName.DEFAULT_RGB;
                } else if (name.equals(COSName.DEVICEGRAY) && resources.hasColorSpace(COSName.DEFAULT_GRAY)) {
                    defaultName = COSName.DEFAULT_GRAY;
                }
                if (resources.hasColorSpace(defaultName)) {
                    return resources.getColorSpace(defaultName);
                }
            }
            if (name == COSName.DEVICERGB || name == COSName.RGB) {
                return PDDeviceRGB.INSTANCE;
            }
            if (name == COSName.DEVICEGRAY || name == COSName.G) {
                return PDDeviceGray.INSTANCE;
            }
            if (resources != null) {
                if (!resources.hasColorSpace(name)) {
                    throw new MissingResourceException("Missing color space: " + name.getName());
                }
                return resources.getColorSpace(name);
            }
            throw new MissingResourceException("Unknown color space: " + name.getName());
        }
        if (colorSpace instanceof COSArray) {
            COSArray array = (COSArray)colorSpace;
            COSName name = (COSName)array.get(0);
            throw new IOException("Invalid color space kind: " + name);
        }
        throw new IOException("Expected a name or array but got: " + colorSpace);
    }

    public abstract String getName();

    public abstract int getNumberOfComponents();

    public abstract float[] getDefaultDecode(int var1);

    public abstract PDColor getInitialColor();

    public abstract float[] toRGB(float[] var1) throws IOException;

    @Override
    public COSBase getCOSObject() {
        return this.array;
    }
}

