/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import android.util.Log;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDTrueTypeFont;
import org.apache.pdfbox.pdmodel.font.encoding.DictionaryEncoding;
import org.apache.pdfbox.pdmodel.font.encoding.Encoding;
import org.apache.pdfbox.pdmodel.font.encoding.GlyphList;
import org.apache.pdfbox.pdmodel.font.encoding.MacRomanEncoding;
import org.apache.pdfbox.pdmodel.font.encoding.StandardEncoding;
import org.apache.pdfbox.pdmodel.font.encoding.WinAnsiEncoding;

public abstract class PDSimpleFont
extends PDFont {
    protected Encoding encoding;
    protected GlyphList glyphList;
    private Boolean isSymbolic;
    private final Set<Integer> noUnicode = new HashSet<Integer>();

    PDSimpleFont() {
    }

    PDSimpleFont(String baseFont) {
        super(baseFont);
        this.encoding = WinAnsiEncoding.INSTANCE;
        this.glyphList = "ZapfDingbats".equals(baseFont) ? GlyphList.getZapfDingbats() : GlyphList.getAdobeGlyphList();
    }

    PDSimpleFont(COSDictionary fontDictionary) throws IOException {
        super(fontDictionary);
    }

    protected final void readEncoding() throws IOException {
        COSBase encoding = this.dict.getDictionaryObject(COSName.ENCODING);
        if (encoding != null) {
            if (encoding instanceof COSName) {
                COSName encodingName = (COSName)encoding;
                this.encoding = Encoding.getInstance(encodingName);
                if (this.encoding == null) {
                    Log.w((String)"PdfBoxAndroid", (String)("Unknown encoding: " + encodingName.getName()));
                    this.encoding = this.readEncodingFromFont();
                }
            } else if (encoding instanceof COSDictionary) {
                boolean isFlaggedAsSymbolic;
                COSDictionary encodingDict = (COSDictionary)encoding;
                Encoding builtIn = null;
                Boolean symbolic = this.getSymbolicFlag();
                boolean bl = isFlaggedAsSymbolic = symbolic != null && symbolic != false;
                if (!encodingDict.containsKey(COSName.BASE_ENCODING) && isFlaggedAsSymbolic) {
                    builtIn = this.readEncodingFromFont();
                }
                if (symbolic == null) {
                    symbolic = false;
                }
                this.encoding = builtIn == null && !encodingDict.containsKey(COSName.BASE_ENCODING) && symbolic.booleanValue() ? null : new DictionaryEncoding(encodingDict, symbolic == false, builtIn);
            }
        } else {
            this.encoding = this.readEncodingFromFont();
        }
        if (this.encoding == null && this.getSymbolicFlag() != null && !this.getSymbolicFlag().booleanValue()) {
            this.encoding = StandardEncoding.INSTANCE;
        }
        if (this.encoding == null && this.isStandard14() && !this.getName().equals("Symbol") && !this.getName().equals("ZapfDingbats")) {
            this.encoding = StandardEncoding.INSTANCE;
        }
        this.glyphList = "ZapfDingbats".equals(this.getName()) ? GlyphList.getZapfDingbats() : GlyphList.getAdobeGlyphList();
    }

    protected abstract Encoding readEncodingFromFont() throws IOException;

    public Encoding getEncoding() {
        return this.encoding;
    }

    public GlyphList getGlyphList() {
        return this.glyphList;
    }

    public final boolean isSymbolic() {
        if (this.isSymbolic == null) {
            Boolean result = this.isFontSymbolic();
            this.isSymbolic = result != null ? result : Boolean.valueOf(true);
        }
        return this.isSymbolic;
    }

    protected Boolean isFontSymbolic() {
        Boolean result = this.getSymbolicFlag();
        if (result != null) {
            return result;
        }
        if (this.isStandard14()) {
            return this.getName().equals("Symbol") || this.getName().equals("ZapfDingbats");
        }
        if (this.encoding == null) {
            if (!(this instanceof PDTrueTypeFont)) {
                throw new IllegalStateException("PDFBox bug: encoding should not be null!");
            }
            return true;
        }
        if (this.encoding instanceof WinAnsiEncoding || this.encoding instanceof MacRomanEncoding || this.encoding instanceof StandardEncoding) {
            return false;
        }
        if (this.encoding instanceof DictionaryEncoding) {
            for (String name : ((DictionaryEncoding)this.encoding).getDifferences().values()) {
                if (name.equals(".notdef") || WinAnsiEncoding.INSTANCE.contains(name) && MacRomanEncoding.INSTANCE.contains(name) && StandardEncoding.INSTANCE.contains(name)) continue;
                return true;
            }
            return false;
        }
        return null;
    }

    protected final Boolean getSymbolicFlag() {
        if (this.getFontDescriptor() != null) {
            return this.getFontDescriptor().isSymbolic();
        }
        return null;
    }

    @Override
    public String toUnicode(int code) throws IOException {
        return this.toUnicode(code, GlyphList.getAdobeGlyphList());
    }

    @Override
    public String toUnicode(int code, GlyphList customGlyphList) throws IOException {
        GlyphList unicodeGlyphList = this.glyphList == GlyphList.getAdobeGlyphList() ? customGlyphList : this.glyphList;
        String unicode = super.toUnicode(code);
        if (unicode != null) {
            return unicode;
        }
        String name = null;
        if (this.encoding != null && (unicode = unicodeGlyphList.toUnicode(name = this.encoding.getName(code))) != null) {
            return unicode;
        }
        if (!this.noUnicode.contains(code)) {
            this.noUnicode.add(code);
            if (name != null) {
                Log.w((String)"PdfBoxAndroid", (String)("No Unicode mapping for " + name + " (" + code + ") in font " + this.getName()));
            } else {
                Log.w((String)"PdfBoxAndroid", (String)("No Unicode mapping for character code " + code + " in font " + this.getName()));
            }
        }
        return null;
    }

    @Override
    public boolean isVertical() {
        return false;
    }

    protected final float getStandard14Width(int code) {
        if (this.getStandard14AFM() != null) {
            String nameInAFM = this.getEncoding().getName(code);
            if (nameInAFM.equals(".notdef")) {
                return 250.0f;
            }
            return this.getStandard14AFM().getCharacterWidth(nameInAFM);
        }
        throw new IllegalStateException("No AFM");
    }

    @Override
    public boolean isStandard14() {
        DictionaryEncoding dictionary;
        if (this.getEncoding() instanceof DictionaryEncoding && (dictionary = (DictionaryEncoding)this.getEncoding()).getDifferences().size() > 0) {
            return false;
        }
        return super.isStandard14();
    }

    @Override
    public void addToSubset(int codePoint) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void subset() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean willBeSubset() {
        return false;
    }
}

