/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.fdf;

import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDNamedTextStream;
import org.apache.pdfbox.pdmodel.common.PDTextStream;

public class FDFJavaScript
implements COSObjectable {
    private COSDictionary js;

    public FDFJavaScript() {
        this.js = new COSDictionary();
    }

    public FDFJavaScript(COSDictionary javaScript) {
        this.js = javaScript;
    }

    @Override
    public COSBase getCOSObject() {
        return this.js;
    }

    public COSDictionary getCOSDictionary() {
        return this.js;
    }

    public PDTextStream getBefore() {
        return PDTextStream.createTextStream(this.js.getDictionaryObject(COSName.BEFORE));
    }

    public void setBefore(PDTextStream before) {
        this.js.setItem(COSName.BEFORE, (COSObjectable)before);
    }

    public PDTextStream getAfter() {
        return PDTextStream.createTextStream(this.js.getDictionaryObject(COSName.AFTER));
    }

    public void setAfter(PDTextStream after) {
        this.js.setItem(COSName.AFTER, (COSObjectable)after);
    }

    public List<PDNamedTextStream> getNamedJavaScripts() {
        COSArray array = (COSArray)this.js.getDictionaryObject(COSName.DOC);
        ArrayList<PDNamedTextStream> namedStreams = new ArrayList<PDNamedTextStream>();
        if (array == null) {
            array = new COSArray();
            this.js.setItem(COSName.DOC, (COSBase)array);
        }
        for (int i = 0; i < array.size(); ++i) {
            COSName name = (COSName)array.get(i);
            COSBase stream = array.get(++i);
            PDNamedTextStream namedStream = new PDNamedTextStream(name, stream);
            namedStreams.add(namedStream);
        }
        return new COSArrayList<PDNamedTextStream>(namedStreams, array);
    }

    public void setNamedJavaScripts(List<PDTextStream> namedStreams) {
        COSArray array = COSArrayList.converterToCOSArray(namedStreams);
        this.js.setItem(COSName.DOC, (COSBase)array);
    }
}

