/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel;

import java.io.IOException;
import java.util.Collections;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.documentinterchange.markedcontent.PDPropertyList;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontFactory;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.optionalcontent.PDOptionalContentGroup;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDAbstractPattern;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShading;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;

public final class PDResources
implements COSObjectable {
    private final COSDictionary resources;

    public PDResources() {
        this.resources = new COSDictionary();
    }

    public PDResources(COSDictionary resourceDictionary) {
        if (resourceDictionary == null) {
            throw new IllegalArgumentException("resourceDictionary is null");
        }
        this.resources = resourceDictionary;
    }

    @Override
    public COSDictionary getCOSObject() {
        return this.resources;
    }

    public PDFont getFont(COSName name) throws IOException {
        COSDictionary dict = (COSDictionary)this.get(COSName.FONT, name);
        if (dict == null) {
            return null;
        }
        return PDFontFactory.createFont(dict);
    }

    public PDColorSpace getColorSpace(COSName name) throws IOException {
        COSBase object = this.get(COSName.COLORSPACE, name);
        if (object != null) {
            return PDColorSpace.create(object, this);
        }
        return PDColorSpace.create(name, this);
    }

    public boolean hasColorSpace(COSName name) {
        return this.get(COSName.COLORSPACE, name) != null;
    }

    public PDExtendedGraphicsState getExtGState(COSName name) throws IOException {
        COSDictionary dict = (COSDictionary)this.get(COSName.EXT_G_STATE, name);
        if (dict == null) {
            return null;
        }
        return new PDExtendedGraphicsState(dict);
    }

    public PDShading getShading(COSName name) throws IOException {
        COSDictionary dict = (COSDictionary)this.get(COSName.SHADING, name);
        if (dict == null) {
            return null;
        }
        return PDShading.create(dict);
    }

    public PDAbstractPattern getPattern(COSName name) throws IOException {
        COSDictionary dict = (COSDictionary)this.get(COSName.PATTERN, name);
        if (dict == null) {
            return null;
        }
        return PDAbstractPattern.create(dict);
    }

    public PDPropertyList getProperties(COSName name) throws IOException {
        COSDictionary dict = (COSDictionary)this.get(COSName.PROPERTIES, name);
        if (dict == null) {
            return null;
        }
        return PDPropertyList.create(dict);
    }

    public PDXObject getXObject(COSName name) throws IOException {
        COSBase value = this.get(COSName.XOBJECT, name);
        if (value == null) {
            return null;
        }
        if (value instanceof COSObject) {
            COSObject object = (COSObject)value;
            String id = name.getName();
            id = id + "#" + object.getObjectNumber();
            return PDXObject.createXObject(object.getObject(), id, this);
        }
        return PDXObject.createXObject(value, name.getName(), this);
    }

    private COSBase get(COSName kind, COSName name) {
        COSDictionary dict = (COSDictionary)this.resources.getDictionaryObject(kind);
        if (dict == null) {
            return null;
        }
        return dict.getDictionaryObject(name);
    }

    public Iterable<COSName> getColorSpaceNames() {
        return this.getNames(COSName.COLORSPACE);
    }

    public Iterable<COSName> getXObjectNames() {
        return this.getNames(COSName.XOBJECT);
    }

    public Iterable<COSName> getFontNames() {
        return this.getNames(COSName.FONT);
    }

    public Iterable<COSName> getPropertiesNames() {
        return this.getNames(COSName.PROPERTIES);
    }

    public Iterable<COSName> getShadingNames() {
        return this.getNames(COSName.SHADING);
    }

    public Iterable<COSName> getPatternNames() {
        return this.getNames(COSName.PATTERN);
    }

    public Iterable<COSName> getExtGStateNames() {
        return this.getNames(COSName.EXT_G_STATE);
    }

    private Iterable<COSName> getNames(COSName kind) {
        COSDictionary dict = (COSDictionary)this.resources.getDictionaryObject(kind);
        if (dict == null) {
            return Collections.emptySet();
        }
        return dict.keySet();
    }

    public COSName add(PDFont font) throws IOException {
        return this.add(COSName.FONT, "F", font);
    }

    public COSName add(PDColorSpace colorSpace) {
        return this.add(COSName.COLORSPACE, "cs", colorSpace);
    }

    public COSName add(PDExtendedGraphicsState extGState) {
        return this.add(COSName.EXT_G_STATE, "gs", extGState);
    }

    public COSName add(PDShading shading) {
        return this.add(COSName.SHADING, "sh", shading);
    }

    public COSName add(PDAbstractPattern pattern) {
        return this.add(COSName.PATTERN, "p", pattern);
    }

    public COSName add(PDPropertyList properties) {
        if (properties instanceof PDOptionalContentGroup) {
            return this.add(COSName.PROPERTIES, "oc", properties);
        }
        return this.add(COSName.PROPERTIES, "Prop", properties);
    }

    public COSName add(PDImageXObject image) {
        return this.add(COSName.XOBJECT, "Im", image);
    }

    public COSName add(PDFormXObject form) {
        return this.add(COSName.XOBJECT, "Form", form);
    }

    public COSName add(PDXObject xobject, String prefix) {
        return this.add(COSName.XOBJECT, prefix, xobject);
    }

    private COSName add(COSName kind, String prefix, COSObjectable object) {
        COSDictionary dict = (COSDictionary)this.resources.getDictionaryObject(kind);
        if (dict != null && dict.containsValue(object.getCOSObject())) {
            return dict.getKeyForValue(object.getCOSObject());
        }
        COSName name = this.createKey(kind, prefix);
        this.put(kind, name, object);
        return name;
    }

    private COSName createKey(COSName kind, String prefix) {
        String key;
        COSDictionary dict = (COSDictionary)this.resources.getDictionaryObject(kind);
        if (dict == null) {
            return COSName.getPDFName(prefix + 1);
        }
        while (dict.containsKey(key = prefix + (dict.keySet().size() + 1))) {
        }
        return COSName.getPDFName(key);
    }

    private void put(COSName kind, COSName name, COSObjectable object) {
        COSDictionary dict = (COSDictionary)this.resources.getDictionaryObject(kind);
        if (dict == null) {
            dict = new COSDictionary();
            this.resources.setItem(kind, (COSBase)dict);
        }
        dict.setItem(name, object);
    }

    public void put(COSName name, PDFont font) throws IOException {
        this.put(COSName.FONT, name, font);
    }

    public void put(COSName name, PDColorSpace colorSpace) throws IOException {
        this.put(COSName.COLORSPACE, name, colorSpace);
    }

    public void put(COSName name, PDExtendedGraphicsState extGState) throws IOException {
        this.put(COSName.EXT_G_STATE, name, extGState);
    }

    public void put(COSName name, PDShading shading) throws IOException {
        this.put(COSName.SHADING, name, shading);
    }

    public void put(COSName name, PDAbstractPattern pattern) throws IOException {
        this.put(COSName.PATTERN, name, pattern);
    }

    public void put(COSName name, PDPropertyList properties) throws IOException {
        this.put(COSName.PROPERTIES, name, properties);
    }

    public void put(COSName name, PDXObject xobject) throws IOException {
        this.put(COSName.XOBJECT, name, xobject);
    }
}

