/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.COSObjectable;

public class PDPageTree
implements COSObjectable,
Iterable<PDPage> {
    private final COSDictionary root;

    public PDPageTree() {
        this.root = new COSDictionary();
        this.root.setItem(COSName.TYPE, (COSBase)COSName.PAGES);
        this.root.setItem(COSName.KIDS, (COSBase)new COSArray());
        this.root.setItem(COSName.COUNT, (COSBase)COSInteger.ZERO);
    }

    public PDPageTree(COSDictionary root) {
        if (root == null) {
            throw new IllegalArgumentException("root cannot be null");
        }
        this.root = root;
    }

    public static COSBase getInheritableAttribute(COSDictionary node, COSName key) {
        COSBase value = node.getDictionaryObject(key);
        if (value != null) {
            return value;
        }
        COSDictionary parent = (COSDictionary)node.getDictionaryObject(COSName.PARENT, COSName.P);
        if (parent != null) {
            return PDPageTree.getInheritableAttribute(parent, key);
        }
        return null;
    }

    @Override
    public Iterator<PDPage> iterator() {
        return new PageIterator(this.root);
    }

    private List<COSDictionary> getKids(COSDictionary node) {
        ArrayList<COSDictionary> result = new ArrayList<COSDictionary>();
        COSArray kids = (COSArray)node.getDictionaryObject(COSName.KIDS);
        if (kids == null) {
            return result;
        }
        int size = kids.size();
        for (int i = 0; i < size; ++i) {
            result.add((COSDictionary)kids.getObject(i));
        }
        return result;
    }

    public PDPage get(int index) {
        COSDictionary dict = this.get(index + 1, this.root, 0);
        if (dict.getCOSName(COSName.TYPE) != COSName.PAGE) {
            throw new IllegalStateException("Expected Page but got " + dict);
        }
        return new PDPage(dict);
    }

    private COSDictionary get(int pageNum, COSDictionary node, int encountered) {
        if (pageNum < 0) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + pageNum);
        }
        if (this.isPageTreeNode(node)) {
            int count = node.getInt(COSName.COUNT, 0);
            if (pageNum <= encountered + count) {
                for (COSDictionary kid : this.getKids(node)) {
                    if (this.isPageTreeNode(kid)) {
                        int kidCount = kid.getInt(COSName.COUNT, 0);
                        if (pageNum <= encountered + kidCount) {
                            return this.get(pageNum, kid, encountered);
                        }
                        encountered += kidCount;
                        continue;
                    }
                    if (pageNum != ++encountered) continue;
                    return this.get(pageNum, kid, encountered);
                }
                throw new IllegalStateException();
            }
            throw new IndexOutOfBoundsException("Index out of bounds: " + pageNum);
        }
        if (encountered == pageNum) {
            return node;
        }
        throw new IllegalStateException();
    }

    private boolean isPageTreeNode(COSDictionary node) {
        return node.getCOSName(COSName.TYPE) == COSName.PAGES || node.containsKey(COSName.KIDS);
    }

    public int indexOf(PDPage page) {
        int num = 0;
        COSDictionary node = page.getCOSObject();
        do {
            if (this.isPageTreeNode(node)) {
                for (COSDictionary kid : this.getKids(node)) {
                    if (kid == node) break;
                    ++num;
                }
            } else {
                ++num;
            }
        } while ((node = (COSDictionary)node.getDictionaryObject(COSName.PARENT, COSName.P)) != null);
        return num - 1;
    }

    public int getCount() {
        return this.root.getInt(COSName.COUNT, 0);
    }

    @Override
    public COSDictionary getCOSObject() {
        return this.root;
    }

    public void remove(int index) {
        COSDictionary node = this.get(index + 1, this.root, 0);
        this.remove(node);
    }

    public void remove(PDPage page) {
        this.remove(page.getCOSObject());
    }

    private void remove(COSDictionary node) {
        COSDictionary parent = (COSDictionary)node.getDictionaryObject(COSName.PARENT, COSName.P);
        COSArray kids = (COSArray)parent.getDictionaryObject(COSName.KIDS);
        if (kids.removeObject(node)) {
            do {
                if ((node = (COSDictionary)node.getDictionaryObject(COSName.PARENT, COSName.P)) == null) continue;
                node.setInt(COSName.COUNT, node.getInt(COSName.COUNT) - 1);
            } while (node != null);
        }
    }

    public void add(PDPage page) {
        COSDictionary node = page.getCOSObject();
        node.setItem(COSName.PARENT, (COSBase)this.root);
        COSArray kids = (COSArray)this.root.getDictionaryObject(COSName.KIDS);
        kids.add(node);
        do {
            if ((node = (COSDictionary)node.getDictionaryObject(COSName.PARENT, COSName.P)) == null) continue;
            node.setInt(COSName.COUNT, node.getInt(COSName.COUNT) + 1);
        } while (node != null);
    }

    private final class PageIterator
    implements Iterator<PDPage> {
        private final Queue<COSDictionary> queue = new ArrayDeque<COSDictionary>();

        private PageIterator(COSDictionary node) {
            this.enqueueKids(node);
        }

        private void enqueueKids(COSDictionary node) {
            if (PDPageTree.this.isPageTreeNode(node)) {
                List kids = PDPageTree.this.getKids(node);
                for (COSDictionary kid : kids) {
                    this.enqueueKids(kid);
                }
            } else {
                this.queue.add(node);
            }
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public PDPage next() {
            COSDictionary next = this.queue.poll();
            if (next.getCOSName(COSName.TYPE) != COSName.PAGE) {
                throw new IllegalStateException("Expected Page but got " + next);
            }
            return new PDPage(next);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

