/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfparser;

import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSUpdateInfo;
import org.apache.pdfbox.pdfparser.BaseParser;
import org.apache.pdfbox.pdfwriter.COSWriter;

public class VisualSignatureParser
extends BaseParser {
    public VisualSignatureParser(InputStream input) throws IOException {
        super(input);
    }

    public void parse() throws IOException {
        block5: {
            this.document = new COSDocument();
            this.skipToNextObj();
            boolean wasLastParsedObjectEOF = false;
            try {
                while (!wasLastParsedObjectEOF && !this.pdfSource.isEOF()) {
                    try {
                        wasLastParsedObjectEOF = this.parseObject();
                    }
                    catch (IOException e) {
                        Log.w((String)"PdfBoxAndroid", (String)"Parsing Error, Skipping Object", (Throwable)e);
                        this.skipToNextObj();
                    }
                    this.skipSpaces();
                }
            }
            catch (IOException e) {
                if (wasLastParsedObjectEOF) break block5;
                throw e;
            }
        }
    }

    protected String readExpectedStringUntilEOL(String theString) throws IOException {
        int c = this.pdfSource.read();
        while (this.isWhitespace(c) && c != -1) {
            c = this.pdfSource.read();
        }
        StringBuilder buffer = new StringBuilder(theString.length());
        for (int charsRead = 0; !this.isEOL(c) && c != -1 && charsRead < theString.length(); ++charsRead) {
            char next = (char)c;
            buffer.append(next);
            if (theString.charAt(charsRead) == next) {
            } else {
                this.pdfSource.unread(buffer.toString().getBytes("ISO-8859-1"));
                throw new IOException("Error: Expected to read '" + theString + "' instead started reading '" + buffer.toString() + "'");
            }
            c = this.pdfSource.read();
        }
        while (this.isEOL(c) && c != -1) {
            c = this.pdfSource.read();
        }
        if (c != -1) {
            this.pdfSource.unread(c);
        }
        return buffer.toString();
    }

    private boolean parseObject() throws IOException {
        boolean isEndOfFile = false;
        this.skipSpaces();
        char peekedChar = (char)this.pdfSource.peek();
        while (peekedChar == 'e') {
            this.readString();
            this.skipSpaces();
            peekedChar = (char)this.pdfSource.peek();
        }
        if (!this.pdfSource.isEOF()) {
            if (peekedChar == 'x') {
                return true;
            }
            if (peekedChar == 't' || peekedChar == 's') {
                if (peekedChar == 't') {
                    return true;
                }
                if (peekedChar == 's') {
                    this.skipToNextObj();
                    String eof = this.readExpectedStringUntilEOL("%%EOF");
                    if (!eof.contains("%%EOF") && !this.pdfSource.isEOF()) {
                        throw new IOException("expected='%%EOF' actual='" + eof + "' next=" + this.readString() + " next=" + this.readString());
                    }
                    isEndOfFile = true;
                }
            } else {
                block18: {
                    COSObjectKey key = this.parseObjectKey(false);
                    this.skipSpaces();
                    COSBase pb = this.parseDirObject();
                    String endObjectKey = this.readString();
                    if (endObjectKey.equals("stream")) {
                        this.pdfSource.unread(endObjectKey.getBytes());
                        this.pdfSource.unread(32);
                        if (!(pb instanceof COSDictionary)) {
                            throw new IOException("stream not preceded by dictionary");
                        }
                        pb = this.parseCOSStream((COSDictionary)pb);
                        endObjectKey = this.readString();
                    }
                    COSObject pdfObject = this.document.getObjectFromPool(key);
                    if (pb instanceof COSUpdateInfo) {
                        ((COSUpdateInfo)((Object)pb)).setNeedToBeUpdated(true);
                    }
                    pdfObject.setObject(pb);
                    if (!endObjectKey.equals("endobj")) {
                        if (endObjectKey.startsWith("endobj")) {
                            this.pdfSource.unread(endObjectKey.substring(6).getBytes());
                        } else if (!this.pdfSource.isEOF()) {
                            try {
                                Float.parseFloat(endObjectKey);
                                this.pdfSource.unread(COSWriter.SPACE);
                                this.pdfSource.unread(endObjectKey.getBytes());
                            }
                            catch (NumberFormatException e) {
                                String secondEndObjectKey = this.readString();
                                if (secondEndObjectKey.equals("endobj")) break block18;
                                if (this.isClosing()) {
                                    this.pdfSource.read();
                                }
                                this.skipSpaces();
                                String thirdPossibleEndObj = this.readString();
                                if (thirdPossibleEndObj.equals("endobj")) break block18;
                                throw new IOException("expected='endobj' firstReadAttempt='" + endObjectKey + "' " + "secondReadAttempt='" + secondEndObjectKey + "' " + this.pdfSource, e);
                            }
                        }
                    }
                }
                this.skipSpaces();
            }
        }
        return isEndOfFile;
    }

    public COSDocument getDocument() throws IOException {
        if (this.document == null) {
            throw new IOException("You must call parse() before calling getDocument()");
        }
        return this.document;
    }
}

