/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfparser;

import android.util.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdfparser.BaseParser;

public class PDFObjectStreamParser
extends BaseParser {
    private List<COSObject> streamObjects = null;
    private final COSStream stream;

    public PDFObjectStreamParser(COSStream strm, COSDocument doc) throws IOException {
        super(strm.getUnfilteredStream());
        this.document = doc;
        this.stream = strm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() throws IOException {
        try {
            COSBase cosObject;
            int numberOfObjects = this.stream.getInt("N");
            ArrayList<Long> objectNumbers = new ArrayList<Long>(numberOfObjects);
            this.streamObjects = new ArrayList<COSObject>(numberOfObjects);
            for (int i = 0; i < numberOfObjects; ++i) {
                long objectNumber = this.readObjectNumber();
                this.readLong();
                objectNumbers.add(objectNumber);
            }
            int objectCounter = 0;
            while ((cosObject = this.parseDirObject()) != null) {
                COSObject object = new COSObject(cosObject);
                object.setGenerationNumber(0);
                if (objectCounter >= objectNumbers.size()) {
                    Log.e((String)"PdfBoxAndroid", (String)("/ObjStm (object stream) has more objects than /N " + numberOfObjects));
                    break;
                }
                object.setObjectNumber((Long)objectNumbers.get(objectCounter));
                this.streamObjects.add(object);
                Log.d((String)"PdfBoxAndroid", (String)("parsed=" + object));
                if (!this.pdfSource.isEOF() && this.pdfSource.peek() == 101) {
                    this.readLine();
                }
                ++objectCounter;
            }
        }
        finally {
            this.pdfSource.close();
        }
    }

    public List<COSObject> getObjects() {
        return this.streamObjects;
    }
}

