/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfparser;

import android.util.Log;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.PushBackInputStream;
import org.apache.pdfbox.io.RandomAccessBufferedFileInputStream;
import org.apache.pdfbox.pdfparser.COSParser;
import org.apache.pdfbox.pdmodel.fdf.FDFDocument;

public class FDFParser
extends COSParser {
    private final RandomAccessBufferedFileInputStream raStream;
    private static final InputStream EMPTY_INPUT_STREAM = new ByteArrayInputStream(new byte[0]);
    private File tempPDFFile;

    public FDFParser(String filename) throws IOException {
        this(new File(filename));
    }

    public FDFParser(File file) throws IOException {
        super(EMPTY_INPUT_STREAM);
        this.fileLen = file.length();
        this.raStream = new RandomAccessBufferedFileInputStream(file);
        this.init();
    }

    public FDFParser(InputStream input) throws IOException {
        super(EMPTY_INPUT_STREAM);
        this.tempPDFFile = this.createTmpFile(input);
        this.fileLen = this.tempPDFFile.length();
        this.raStream = new RandomAccessBufferedFileInputStream(this.tempPDFFile);
        this.init();
    }

    private void init() throws IOException {
        String eofLookupRangeStr = System.getProperty("org.apache.pdfbox.pdfparser.nonSequentialPDFParser.eofLookupRange");
        if (eofLookupRangeStr != null) {
            try {
                this.setEOFLookupRange(Integer.parseInt(eofLookupRangeStr));
            }
            catch (NumberFormatException nfe) {
                Log.w((String)"PdfBoxAndroid", (String)("System property org.apache.pdfbox.pdfparser.nonSequentialPDFParser.eofLookupRange does not contain an integer value, but: '" + eofLookupRangeStr + "'"));
            }
        }
        this.document = new COSDocument(false);
        this.pdfSource = new PushBackInputStream(this.raStream, 4096);
    }

    private void initialParse() throws IOException {
        COSDictionary trailer = null;
        long startXRefOffset = this.getStartxrefOffset();
        trailer = startXRefOffset > 0L ? this.parseXref(startXRefOffset) : this.rebuildTrailer();
        for (COSBase trailerEntry : trailer.getValues()) {
            if (!(trailerEntry instanceof COSObject)) continue;
            COSObject tmpObj = (COSObject)trailerEntry;
            this.parseObjectDynamically(tmpObj, false);
        }
        COSObject root = (COSObject)trailer.getItem(COSName.ROOT);
        if (root == null) {
            throw new IOException("Missing root object specification in trailer.");
        }
        COSBase rootObject = this.parseObjectDynamically(root, false);
        if (rootObject instanceof COSDictionary) {
            this.parseDictObjects((COSDictionary)rootObject, null);
        }
        this.initialParseDone = true;
    }

    public void parse() throws IOException {
        boolean exceptionOccurred = true;
        try {
            if (!this.parseFDFHeader()) {
                throw new IOException("Error: Header doesn't contain versioninfo");
            }
            this.initialParse();
            exceptionOccurred = false;
        }
        finally {
            IOUtils.closeQuietly(this.pdfSource);
            this.deleteTempFile();
            if (exceptionOccurred && this.document != null) {
                try {
                    this.document.close();
                    this.document = null;
                }
                catch (IOException iOException) {}
            }
        }
    }

    public FDFDocument getFDFDocument() throws IOException {
        return new FDFDocument(this.getDocument());
    }

    private void deleteTempFile() {
        if (this.tempPDFFile != null) {
            try {
                if (!this.tempPDFFile.delete()) {
                    Log.w((String)"PdfBoxAndroid", (String)("Temporary file '" + this.tempPDFFile.getName() + "' can't be deleted"));
                }
            }
            catch (SecurityException e) {
                Log.w((String)"PdfBoxAndroid", (String)("Temporary file '" + this.tempPDFFile.getName() + "' can't be deleted"), (Throwable)e);
            }
        }
    }
}

