/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdfparser;

import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSDocument;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNull;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdfparser.BaseParser;
import org.apache.pdfbox.pdfparser.EndstreamOutputStream;
import org.apache.pdfbox.pdfparser.PDFObjectStreamParser;
import org.apache.pdfbox.pdfparser.PDFXrefStreamParser;
import org.apache.pdfbox.pdfparser.XrefTrailerResolver;
import org.apache.pdfbox.pdmodel.encryption.SecurityHandler;

public class COSParser
extends BaseParser {
    private static final String PDF_HEADER = "%PDF-";
    private static final String FDF_HEADER = "%FDF-";
    private static final String PDF_DEFAULT_VERSION = "1.4";
    private static final String FDF_DEFAULT_VERSION = "1.0";
    private static final char[] XREF_TABLE = new char[]{'x', 'r', 'e', 'f'};
    private static final char[] XREF_STREAM = new char[]{'/', 'X', 'R', 'e', 'f'};
    private static final char[] STARTXREF = new char[]{'s', 't', 'a', 'r', 't', 'x', 'r', 'e', 'f'};
    private static final long MINIMUM_SEARCH_OFFSET = 6L;
    private static final int X = 120;
    public static final String SYSPROP_PARSEMINIMAL = "org.apache.pdfbox.pdfparser.nonSequentialPDFParser.parseMinimal";
    public static final String SYSPROP_EOFLOOKUPRANGE = "org.apache.pdfbox.pdfparser.nonSequentialPDFParser.eofLookupRange";
    private static final int DEFAULT_TRAIL_BYTECOUNT = 2048;
    protected static final char[] EOF_MARKER = new char[]{'%', '%', 'E', 'O', 'F'};
    protected static final char[] OBJ_MARKER = new char[]{'o', 'b', 'j'};
    private long trailerOffset;
    protected long fileLen;
    private boolean isLenient = true;
    protected boolean initialParseDone = false;
    private Map<COSObjectKey, Long> bfSearchCOSObjectKeyOffsets = null;
    private List<Long> bfSearchXRefTablesOffsets = null;
    private List<Long> bfSearchXRefStreamsOffsets = null;
    protected SecurityHandler securityHandler = null;
    private int readTrailBytes = 2048;
    private final boolean parseMinimalCatalog = "true".equals(System.getProperty("org.apache.pdfbox.pdfparser.nonSequentialPDFParser.parseMinimal"));
    protected XrefTrailerResolver xrefTrailerResolver = new XrefTrailerResolver();
    public static final String TMP_FILE_PREFIX = "tmpPDF";
    private boolean inGetLength = false;
    private static final int STREAMCOPYBUFLEN = 8192;
    private final byte[] streamCopyBuf = new byte[8192];

    public COSParser(InputStream input) throws IOException {
        super(input);
    }

    public void setEOFLookupRange(int byteCount) {
        if (byteCount > 15) {
            this.readTrailBytes = byteCount;
        }
    }

    protected COSDictionary parseXref(long startXRefOffset) throws IOException {
        COSDictionary trailer;
        this.pdfSource.seek(startXRefOffset);
        long startXrefOffset = Math.max(0L, this.parseStartXref());
        long fixedOffset = this.checkXRefOffset(startXrefOffset);
        if (fixedOffset > -1L) {
            startXrefOffset = fixedOffset;
        }
        this.document.setStartXref(startXrefOffset);
        long prev = startXrefOffset;
        while (prev > -1L) {
            this.pdfSource.seek(prev);
            this.skipSpaces();
            if (this.pdfSource.peek() == 120) {
                this.parseXrefTable(prev);
                this.trailerOffset = this.pdfSource.getOffset();
                while (this.isLenient && this.pdfSource.peek() != 116) {
                    if (this.pdfSource.getOffset() == this.trailerOffset) {
                        Log.w((String)"PdfBoxAndroid", (String)("Expected trailer object at position " + this.trailerOffset + ", keep trying"));
                    }
                    this.readLine();
                }
                if (!this.parseTrailer()) {
                    throw new IOException("Expected trailer object at position: " + this.pdfSource.getOffset());
                }
                trailer = this.xrefTrailerResolver.getCurrentTrailer();
                if (trailer.containsKey(COSName.XREF_STM)) {
                    int streamOffset = trailer.getInt(COSName.XREF_STM);
                    fixedOffset = this.checkXRefStreamOffset(streamOffset, false);
                    if (fixedOffset > -1L && fixedOffset != (long)streamOffset) {
                        streamOffset = (int)fixedOffset;
                        trailer.setInt(COSName.XREF_STM, streamOffset);
                    }
                    if (streamOffset > 0) {
                        this.pdfSource.seek(streamOffset);
                        this.skipSpaces();
                        this.parseXrefObjStream(prev, false);
                    } else if (this.isLenient) {
                        Log.e((String)"PdfBoxAndroid", (String)("Skipped XRef stream due to a corrupt offset:" + streamOffset));
                    } else {
                        throw new IOException("Skipped XRef stream due to a corrupt offset:" + streamOffset);
                    }
                }
                if ((prev = (long)trailer.getInt(COSName.PREV)) <= -1L || (fixedOffset = this.checkXRefOffset(prev)) <= -1L || fixedOffset == prev) continue;
                prev = fixedOffset;
                trailer.setLong(COSName.PREV, prev);
                continue;
            }
            if ((prev = this.parseXrefObjStream(prev, true)) <= -1L || (fixedOffset = this.checkXRefOffset(prev)) <= -1L || fixedOffset == prev) continue;
            prev = fixedOffset;
            trailer = this.xrefTrailerResolver.getCurrentTrailer();
            trailer.setLong(COSName.PREV, prev);
        }
        this.xrefTrailerResolver.setStartxref(startXrefOffset);
        trailer = this.xrefTrailerResolver.getTrailer();
        this.document.setTrailer(trailer);
        this.document.setIsXRefStream(XrefTrailerResolver.XRefType.STREAM == this.xrefTrailerResolver.getXrefType());
        this.checkXrefOffsets();
        this.document.addXRefTable(this.xrefTrailerResolver.getXrefTable());
        return trailer;
    }

    private long parseXrefObjStream(long objByteOffset, boolean isStandalone) throws IOException {
        this.readObjectNumber();
        this.readGenerationNumber();
        this.readExpectedString(OBJ_MARKER, true);
        COSDictionary dict = this.parseCOSDictionary();
        COSStream xrefStream = this.parseCOSStream(dict);
        this.parseXrefStream(xrefStream, (int)objByteOffset, isStandalone);
        xrefStream.close();
        return dict.getLong(COSName.PREV);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final long getStartxrefOffset() throws IOException {
        long skipBytes;
        byte[] buf;
        try {
            int readBytes;
            int trailByteCount = this.fileLen < (long)this.readTrailBytes ? (int)this.fileLen : this.readTrailBytes;
            buf = new byte[trailByteCount];
            skipBytes = this.fileLen - (long)trailByteCount;
            this.pdfSource.seek(skipBytes);
            for (int off = 0; off < trailByteCount; off += readBytes) {
                readBytes = this.pdfSource.read(buf, off, trailByteCount - off);
                if (readBytes >= 1) continue;
                throw new IOException("No more bytes to read for trailing buffer, but expected: " + (trailByteCount - off));
            }
        }
        finally {
            this.pdfSource.seek(0L);
        }
        int bufOff = this.lastIndexOf(EOF_MARKER, buf, buf.length);
        if (bufOff < 0) {
            if (this.isLenient) {
                bufOff = buf.length;
                Log.d((String)"PdfBoxAndroid", (String)("Missing end of file marker '" + new String(EOF_MARKER) + "'"));
            } else {
                throw new IOException("Missing end of file marker '" + new String(EOF_MARKER) + "'");
            }
        }
        bufOff = this.lastIndexOf(STARTXREF, buf, bufOff);
        long startXRefOffset = skipBytes + (long)bufOff;
        if (bufOff < 0) {
            if (this.isLenient) {
                Log.d((String)"PdfBoxAndroid", (String)"Can't find offset for startxref");
                return -1L;
            }
            throw new IOException("Missing 'startxref' marker.");
        }
        return startXRefOffset;
    }

    protected int lastIndexOf(char[] pattern, byte[] buf, int endOff) {
        int lastPatternChOff = pattern.length - 1;
        int bufOff = endOff;
        int patOff = lastPatternChOff;
        char lookupCh = pattern[patOff];
        while (--bufOff >= 0) {
            if (buf[bufOff] == lookupCh) {
                if (--patOff < 0) {
                    return bufOff;
                }
                lookupCh = pattern[patOff];
                continue;
            }
            if (patOff >= lastPatternChOff) continue;
            patOff = lastPatternChOff;
            lookupCh = pattern[patOff];
        }
        return -1;
    }

    public boolean isLenient() {
        return this.isLenient;
    }

    public void setLenient(boolean lenient) {
        if (this.initialParseDone) {
            throw new IllegalArgumentException("Cannot change leniency after parsing");
        }
        this.isLenient = lenient;
    }

    private long getObjectId(COSObject obj) {
        return obj.getObjectNumber() << 32 | (long)obj.getGenerationNumber();
    }

    private void addNewToList(Queue<COSBase> toBeParsedList, Collection<COSBase> newObjects, Set<Long> addedObjects) {
        for (COSBase newObject : newObjects) {
            this.addNewToList(toBeParsedList, newObject, addedObjects);
        }
    }

    private void addNewToList(Queue<COSBase> toBeParsedList, COSBase newObject, Set<Long> addedObjects) {
        long objId;
        if (newObject instanceof COSObject && !addedObjects.add(objId = this.getObjectId((COSObject)newObject))) {
            return;
        }
        toBeParsedList.add(newObject);
    }

    protected void parseDictObjects(COSDictionary dict, COSName ... excludeObjects) throws IOException {
        LinkedList<COSBase> toBeParsedList = new LinkedList<COSBase>();
        TreeMap<Long, List<COSObject>> objToBeParsed = new TreeMap<Long, List<COSObject>>();
        HashSet<Long> parsedObjects = new HashSet<Long>();
        HashSet<Long> addedObjects = new HashSet<Long>();
        this.addExcludedToList(excludeObjects, dict, parsedObjects);
        this.addNewToList(toBeParsedList, dict.getValues(), addedObjects);
        while (!toBeParsedList.isEmpty() || !objToBeParsed.isEmpty()) {
            COSBase baseObj;
            while ((baseObj = (COSBase)toBeParsedList.poll()) != null) {
                if (baseObj instanceof COSDictionary) {
                    this.addNewToList(toBeParsedList, ((COSDictionary)baseObj).getValues(), addedObjects);
                    continue;
                }
                if (baseObj instanceof COSArray) {
                    Iterator<COSBase> arrIter = ((COSArray)baseObj).iterator();
                    while (arrIter.hasNext()) {
                        this.addNewToList(toBeParsedList, arrIter.next(), addedObjects);
                    }
                    continue;
                }
                if (!(baseObj instanceof COSObject)) continue;
                COSObject obj = (COSObject)baseObj;
                long objId = this.getObjectId(obj);
                COSObjectKey objKey = new COSObjectKey(obj.getObjectNumber(), obj.getGenerationNumber());
                if (parsedObjects.contains(objId)) continue;
                Long fileOffset = this.xrefTrailerResolver.getXrefTable().get(objKey);
                if (fileOffset != null && fileOffset != 0L) {
                    if (fileOffset > 0L) {
                        objToBeParsed.put(fileOffset, Collections.singletonList(obj));
                        continue;
                    }
                    fileOffset = this.xrefTrailerResolver.getXrefTable().get(new COSObjectKey((int)(-fileOffset.longValue()), 0));
                    if (fileOffset == null || fileOffset <= 0L) {
                        throw new IOException("Invalid object stream xref object reference for key '" + objKey + "': " + fileOffset);
                    }
                    ArrayList<COSObject> stmObjects = (ArrayList<COSObject>)objToBeParsed.get(fileOffset);
                    if (stmObjects == null) {
                        stmObjects = new ArrayList<COSObject>();
                        objToBeParsed.put(fileOffset, stmObjects);
                    }
                    stmObjects.add(obj);
                    continue;
                }
                COSObject pdfObject = this.document.getObjectFromPool(objKey);
                pdfObject.setObject(COSNull.NULL);
            }
            if (objToBeParsed.isEmpty()) break;
            for (COSObject obj : (List)objToBeParsed.remove(objToBeParsed.firstKey())) {
                COSBase parsedObj = this.parseObjectDynamically(obj, false);
                obj.setObject(parsedObj);
                this.addNewToList(toBeParsedList, parsedObj, addedObjects);
                parsedObjects.add(this.getObjectId(obj));
            }
        }
    }

    private void addExcludedToList(COSName[] excludeObjects, COSDictionary dict, Set<Long> parsedObjects) {
        if (excludeObjects != null) {
            for (COSName objName : excludeObjects) {
                COSBase baseObj = dict.getItem(objName);
                if (!(baseObj instanceof COSObject)) continue;
                parsedObjects.add(this.getObjectId((COSObject)baseObj));
            }
        }
    }

    protected final COSBase parseObjectDynamically(COSObject obj, boolean requireExistingNotCompressedObj) throws IOException {
        return this.parseObjectDynamically(obj.getObjectNumber(), obj.getGenerationNumber(), requireExistingNotCompressedObj);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected COSBase parseObjectDynamically(long objNr, int objGenNr, boolean requireExistingNotCompressedObj) throws IOException {
        COSObjectKey objKey = new COSObjectKey(objNr, objGenNr);
        COSObject pdfObject = this.document.getObjectFromPool(objKey);
        if (pdfObject.getObject() != null) return pdfObject.getObject();
        Long offsetOrObjstmObNr = this.xrefTrailerResolver.getXrefTable().get(objKey);
        if (requireExistingNotCompressedObj && (offsetOrObjstmObNr == null || offsetOrObjstmObNr <= 0L)) {
            throw new IOException("Object must be defined and must not be compressed object: " + objKey.getNumber() + ":" + objKey.getGeneration());
        }
        if (offsetOrObjstmObNr == null) {
            pdfObject.setObject(COSNull.NULL);
            return pdfObject.getObject();
        } else if (offsetOrObjstmObNr > 0L) {
            this.pdfSource.seek(offsetOrObjstmObNr);
            long readObjNr = this.readObjectNumber();
            int readObjGen = this.readGenerationNumber();
            this.readExpectedString(OBJ_MARKER, true);
            if (readObjNr != objKey.getNumber() || readObjGen != objKey.getGeneration()) {
                throw new IOException("XREF for " + objKey.getNumber() + ":" + objKey.getGeneration() + " points to wrong object: " + readObjNr + ":" + readObjGen);
            }
            this.skipSpaces();
            COSBase pb = this.parseDirObject();
            String endObjectKey = this.readString();
            if (endObjectKey.equals("stream")) {
                this.pdfSource.unread(endObjectKey.getBytes("ISO-8859-1"));
                this.pdfSource.unread(32);
                if (!(pb instanceof COSDictionary)) throw new IOException("Stream not preceded by dictionary (offset: " + offsetOrObjstmObNr + ").");
                COSStream stream = this.parseCOSStream((COSDictionary)pb);
                if (this.securityHandler != null) {
                    this.securityHandler.decryptStream(stream, objNr, objGenNr);
                }
                pb = stream;
                this.skipSpaces();
                endObjectKey = this.readLine();
                if (!endObjectKey.startsWith("endobj") && endObjectKey.startsWith("endstream") && (endObjectKey = endObjectKey.substring(9).trim()).length() == 0) {
                    endObjectKey = this.readLine();
                }
            } else if (this.securityHandler != null) {
                this.securityHandler.decrypt(pb, objNr, objGenNr);
            }
            pdfObject.setObject(pb);
            if (endObjectKey.startsWith("endobj")) return pdfObject.getObject();
            if (!this.isLenient) throw new IOException("Object (" + readObjNr + ":" + readObjGen + ") at offset " + offsetOrObjstmObNr + " does not end with 'endobj' but with '" + endObjectKey + "'");
            Log.w((String)"PdfBoxAndroid", (String)("Object (" + readObjNr + ":" + readObjGen + ") at offset " + offsetOrObjstmObNr + " does not end with 'endobj' but with '" + endObjectKey + "'"));
            return pdfObject.getObject();
        } else {
            int objstmObjNr = (int)(-offsetOrObjstmObNr.longValue());
            COSBase objstmBaseObj = this.parseObjectDynamically(objstmObjNr, 0, true);
            if (!(objstmBaseObj instanceof COSStream)) return pdfObject.getObject();
            PDFObjectStreamParser parser = new PDFObjectStreamParser((COSStream)objstmBaseObj, this.document);
            parser.parse();
            parser.close();
            Set<Long> refObjNrs = this.xrefTrailerResolver.getContainedObjectNumbers(objstmObjNr);
            for (COSObject next : parser.getObjects()) {
                COSObjectKey stmObjKey = new COSObjectKey(next);
                if (!refObjNrs.contains(stmObjKey.getNumber())) continue;
                COSObject stmObj = this.document.getObjectFromPool(stmObjKey);
                stmObj.setObject(next.getObject());
            }
        }
        return pdfObject.getObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private COSNumber getLength(COSBase lengthBaseObj) throws IOException {
        COSNumber retVal;
        block10: {
            if (lengthBaseObj == null) {
                return null;
            }
            if (this.inGetLength) {
                throw new IOException("Loop while reading length from " + lengthBaseObj);
            }
            retVal = null;
            try {
                this.inGetLength = true;
                if (lengthBaseObj instanceof COSNumber) {
                    retVal = (COSNumber)lengthBaseObj;
                    break block10;
                }
                if (lengthBaseObj instanceof COSObject) {
                    COSObject lengthObj = (COSObject)lengthBaseObj;
                    if (lengthObj.getObject() == null) {
                        long curFileOffset = this.pdfSource.getOffset();
                        this.parseObjectDynamically(lengthObj, true);
                        this.pdfSource.seek(curFileOffset);
                        if (lengthObj.getObject() == null) {
                            throw new IOException("Length object content was not read.");
                        }
                    }
                    if (!(lengthObj.getObject() instanceof COSNumber)) {
                        throw new IOException("Wrong type of referenced length object " + lengthObj + ": " + lengthObj.getObject().getClass().getSimpleName());
                    }
                    retVal = (COSNumber)lengthObj.getObject();
                    break block10;
                }
                throw new IOException("Wrong type of length object: " + lengthBaseObj.getClass().getSimpleName());
            }
            finally {
                this.inGetLength = false;
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected COSStream parseCOSStream(COSDictionary dic) throws IOException {
        COSStream stream = this.createCOSStream(dic);
        try (OutputStream out = null;){
            String endStream;
            COSNumber streamLengthObj;
            this.readString();
            int whitespace = this.pdfSource.read();
            while (whitespace == 32) {
                whitespace = this.pdfSource.read();
            }
            if (whitespace == 13) {
                whitespace = this.pdfSource.read();
                if (whitespace != 10) {
                    this.pdfSource.unread(whitespace);
                }
            } else if (whitespace != 10) {
                this.pdfSource.unread(whitespace);
            }
            if ((streamLengthObj = this.getLength(dic.getItem(COSName.LENGTH))) == null) {
                if (this.isLenient) {
                    Log.w((String)"PdfBoxAndroid", (String)"The stream doesn't provide any stream length, using fallback readUntilEnd");
                } else {
                    throw new IOException("Missing length for stream.");
                }
            }
            boolean useReadUntilEnd = false;
            if (streamLengthObj != null && this.validateStreamLength(streamLengthObj.longValue())) {
                out = stream.createFilteredStream(streamLengthObj);
                long remainBytes = streamLengthObj.longValue();
                int bytesRead = 0;
                while (remainBytes > 0L) {
                    int readBytes = this.pdfSource.read(this.streamCopyBuf, 0, remainBytes > 8192L ? 8192 : (int)remainBytes);
                    if (readBytes <= 0) {
                        useReadUntilEnd = true;
                        out.close();
                        this.pdfSource.unread(bytesRead);
                        break;
                    }
                    out.write(this.streamCopyBuf, 0, readBytes);
                    remainBytes -= (long)readBytes;
                    bytesRead += readBytes;
                }
            } else {
                useReadUntilEnd = true;
            }
            if (useReadUntilEnd) {
                out = stream.createFilteredStream();
                this.readUntilEndStream(new EndstreamOutputStream(out));
            }
            if ((endStream = this.readString()).equals("endobj") && this.isLenient) {
                Log.w((String)"PdfBoxAndroid", (String)("stream ends with 'endobj' instead of 'endstream' at offset " + this.pdfSource.getOffset()));
                this.pdfSource.unread(ENDOBJ);
            } else if (endStream.length() > 9 && this.isLenient && endStream.substring(0, 9).equals("endstream")) {
                Log.w((String)"PdfBoxAndroid", (String)("stream ends with '" + endStream + "' instead of 'endstream' at offset " + this.pdfSource.getOffset()));
                this.pdfSource.unread(endStream.substring(9).getBytes("ISO-8859-1"));
            } else if (!endStream.equals("endstream")) {
                throw new IOException("Error reading stream, expected='endstream' actual='" + endStream + "' at offset " + this.pdfSource.getOffset());
            }
        }
        return stream;
    }

    private boolean validateStreamLength(long streamLength) throws IOException {
        boolean streamLengthIsValid = true;
        long originOffset = this.pdfSource.getOffset();
        long expectedEndOfStream = originOffset + streamLength;
        if (expectedEndOfStream > this.fileLen) {
            streamLengthIsValid = false;
            Log.e((String)"PdfBoxAndroid", (String)("The end of the stream is out of range, using workaround to read the stream, found " + originOffset + " but expected " + expectedEndOfStream));
        } else {
            this.pdfSource.seek(expectedEndOfStream);
            this.skipSpaces();
            if (!this.isString(ENDSTREAM)) {
                streamLengthIsValid = false;
                Log.e((String)"PdfBoxAndroid", (String)("The end of the stream doesn't point to the correct offset, using workaround to read the stream, found " + originOffset + " but expected " + expectedEndOfStream));
            }
            this.pdfSource.seek(originOffset);
        }
        return streamLengthIsValid;
    }

    private long checkXRefOffset(long startXRefOffset) throws IOException {
        long fixedOffset;
        if (!this.isLenient) {
            return startXRefOffset;
        }
        this.pdfSource.seek(startXRefOffset);
        if (this.pdfSource.peek() == 120 && this.isString(XREF_TABLE)) {
            return startXRefOffset;
        }
        if (startXRefOffset > 0L && (fixedOffset = this.checkXRefStreamOffset(startXRefOffset, true)) > -1L) {
            return fixedOffset;
        }
        return this.calculateXRefFixedOffset(startXRefOffset, false);
    }

    private long checkXRefStreamOffset(long startXRefOffset, boolean checkOnly) throws IOException {
        if (!this.isLenient || startXRefOffset == 0L) {
            return startXRefOffset;
        }
        this.pdfSource.seek(startXRefOffset - 1L);
        int nextValue = this.pdfSource.read();
        if (this.isWhitespace(nextValue) && (nextValue = this.pdfSource.peek()) > 47 && nextValue < 58) {
            try {
                this.readObjectNumber();
                this.readGenerationNumber();
                this.readExpectedString(OBJ_MARKER, true);
                this.pdfSource.seek(startXRefOffset);
                return startXRefOffset;
            }
            catch (IOException exception) {
                this.pdfSource.seek(startXRefOffset);
            }
        }
        return checkOnly ? -1L : this.calculateXRefFixedOffset(startXRefOffset, true);
    }

    private long calculateXRefFixedOffset(long objectOffset, boolean streamsOnly) throws IOException {
        if (objectOffset < 0L) {
            Log.e((String)"PdfBoxAndroid", (String)("Invalid object offset " + objectOffset + " when searching for a xref table/stream"));
            return 0L;
        }
        long newOffset = this.bfSearchForXRef(objectOffset, streamsOnly);
        if (newOffset > -1L) {
            Log.d((String)"PdfBoxAndroid", (String)("Fixed reference for xref table/stream " + objectOffset + " -> " + newOffset));
            return newOffset;
        }
        Log.e((String)"PdfBoxAndroid", (String)("Can't find the object axref table/stream at offset " + objectOffset));
        return 0L;
    }

    private void checkXrefOffsets() throws IOException {
        if (!this.isLenient) {
            return;
        }
        Map<COSObjectKey, Long> xrefOffset = this.xrefTrailerResolver.getXrefTable();
        if (xrefOffset != null) {
            boolean bruteForceSearch = false;
            for (Map.Entry<COSObjectKey, Long> objectEntry : xrefOffset.entrySet()) {
                COSObjectKey objectKey = objectEntry.getKey();
                Long objectOffset = objectEntry.getValue();
                if (objectOffset == null || objectOffset < 0L || this.checkObjectKeys(objectKey, objectOffset)) continue;
                Log.d((String)"PdfBoxAndroid", (String)"Stop checking xref offsets as at least one couldn't be dereferenced");
                bruteForceSearch = true;
                break;
            }
            if (bruteForceSearch) {
                this.bfSearchForObjects();
                if (this.bfSearchCOSObjectKeyOffsets != null && !this.bfSearchCOSObjectKeyOffsets.isEmpty()) {
                    Log.d((String)"PdfBoxAndroid", (String)"Replaced read xref table with the results of a brute force search");
                    xrefOffset.putAll(this.bfSearchCOSObjectKeyOffsets);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkObjectKeys(COSObjectKey objectKey, long offset) throws IOException {
        if (offset < 6L) {
            return false;
        }
        long objectNr = objectKey.getNumber();
        int objectGen = objectKey.getGeneration();
        long originOffset = this.pdfSource.getOffset();
        this.pdfSource.seek(offset);
        String objectString = this.createObjectString(objectNr, objectGen);
        try {
            if (this.isString(objectString.getBytes("ISO-8859-1"))) {
                this.pdfSource.seek(originOffset);
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException exception) {
        }
        finally {
            this.pdfSource.seek(originOffset);
        }
        return false;
    }

    private String createObjectString(long objectID, int genID) {
        return Long.toString(objectID) + " " + Integer.toString(genID) + " obj";
    }

    private void bfSearchForObjects() throws IOException {
        if (this.bfSearchCOSObjectKeyOffsets == null) {
            this.bfSearchCOSObjectKeyOffsets = new HashMap<COSObjectKey, Long>();
            long originOffset = this.pdfSource.getOffset();
            long currentOffset = 6L;
            String objString = " obj";
            char[] string = objString.toCharArray();
            do {
                this.pdfSource.seek(currentOffset);
                if (this.isString(string)) {
                    long tempOffset = currentOffset - 1L;
                    this.pdfSource.seek(tempOffset);
                    int genID = this.pdfSource.peek();
                    if (genID > 47 && genID < 58) {
                        genID -= 48;
                        this.pdfSource.seek(--tempOffset);
                        if (this.isSpace()) {
                            while (tempOffset > 6L && this.isSpace()) {
                                this.pdfSource.seek(--tempOffset);
                            }
                            int length = 0;
                            while (tempOffset > 6L && this.isDigit()) {
                                this.pdfSource.seek(--tempOffset);
                                ++length;
                            }
                            if (length > 0) {
                                Long objectID;
                                this.pdfSource.read();
                                byte[] objIDBytes = this.pdfSource.readFully(length);
                                String objIdString = new String(objIDBytes, 0, objIDBytes.length, "ISO-8859-1");
                                try {
                                    objectID = Long.valueOf(objIdString);
                                }
                                catch (NumberFormatException exception) {
                                    objectID = null;
                                }
                                if (objectID != null) {
                                    this.bfSearchCOSObjectKeyOffsets.put(new COSObjectKey(objectID, genID), tempOffset + 1L);
                                }
                            }
                        }
                    }
                }
                ++currentOffset;
            } while (!this.pdfSource.isEOF());
            this.pdfSource.seek(originOffset);
        }
    }

    private long bfSearchForXRef(long xrefOffset, boolean streamsOnly) throws IOException {
        long newOffset = -1L;
        long newOffsetTable = -1L;
        long newOffsetStream = -1L;
        if (!streamsOnly) {
            this.bfSearchForXRefTables();
        }
        this.bfSearchForXRefStreams();
        if (!streamsOnly && this.bfSearchXRefTablesOffsets != null) {
            newOffsetTable = this.searchNearestValue(this.bfSearchXRefTablesOffsets, xrefOffset);
        }
        if (this.bfSearchXRefStreamsOffsets != null) {
            newOffsetStream = this.searchNearestValue(this.bfSearchXRefStreamsOffsets, xrefOffset);
        }
        if (newOffsetTable > -1L && newOffsetStream > -1L) {
            long differenceTable = xrefOffset - newOffsetTable;
            long differenceStream = xrefOffset - newOffsetStream;
            if (Math.abs(differenceTable) > Math.abs(differenceStream)) {
                newOffset = differenceStream;
                this.bfSearchXRefStreamsOffsets.remove(newOffsetStream);
            } else {
                newOffset = differenceTable;
                this.bfSearchXRefTablesOffsets.remove(newOffsetTable);
            }
        } else if (newOffsetTable > -1L) {
            newOffset = newOffsetTable;
            this.bfSearchXRefTablesOffsets.remove(newOffsetTable);
        } else if (newOffsetStream > -1L) {
            newOffset = newOffsetStream;
            this.bfSearchXRefStreamsOffsets.remove(newOffsetStream);
        }
        return newOffset;
    }

    private long searchNearestValue(List<Long> values, long offset) {
        long newValue = -1L;
        long currentDifference = -1L;
        int currentOffsetIndex = -1;
        int numberOfOffsets = values.size();
        for (int i = 0; i < numberOfOffsets; ++i) {
            long newDifference = offset - values.get(i);
            if (currentDifference != -1L && Math.abs(currentDifference) <= Math.abs(newDifference)) continue;
            currentDifference = newDifference;
            currentOffsetIndex = i;
        }
        if (currentOffsetIndex > -1) {
            newValue = values.get(currentOffsetIndex);
        }
        return newValue;
    }

    private void bfSearchForXRefTables() throws IOException {
        if (this.bfSearchXRefTablesOffsets == null) {
            this.bfSearchXRefTablesOffsets = new Vector<Long>();
            long originOffset = this.pdfSource.getOffset();
            this.pdfSource.seek(6L);
            while (!this.pdfSource.isEOF()) {
                if (this.isString(XREF_TABLE)) {
                    long newOffset = this.pdfSource.getOffset();
                    this.pdfSource.seek(newOffset - 1L);
                    if (this.isWhitespace()) {
                        this.bfSearchXRefTablesOffsets.add(newOffset);
                    }
                    this.pdfSource.seek(newOffset + 4L);
                }
                this.pdfSource.read();
            }
            this.pdfSource.seek(originOffset);
        }
    }

    private void bfSearchForXRefStreams() throws IOException {
        if (this.bfSearchXRefStreamsOffsets == null) {
            this.bfSearchXRefStreamsOffsets = new Vector<Long>();
            long originOffset = this.pdfSource.getOffset();
            this.pdfSource.seek(6L);
            String objString = " obj";
            char[] string = objString.toCharArray();
            while (!this.pdfSource.isEOF()) {
                if (this.isString(XREF_STREAM)) {
                    long newOffset = -1L;
                    long xrefOffset = this.pdfSource.getOffset();
                    boolean objFound = false;
                    block1: for (int i = 1; i < 30 && !objFound; ++i) {
                        long currentOffset = xrefOffset - (long)(i * 10);
                        if (currentOffset <= 0L) continue;
                        this.pdfSource.seek(currentOffset);
                        for (int j = 0; j < 10; ++j) {
                            if (this.isString(string)) {
                                long tempOffset = currentOffset - 1L;
                                this.pdfSource.seek(tempOffset);
                                int genID = this.pdfSource.peek();
                                if (this.isDigit(genID)) {
                                    genID -= 48;
                                    this.pdfSource.seek(--tempOffset);
                                    if (this.isSpace()) {
                                        int length = 0;
                                        this.pdfSource.seek(--tempOffset);
                                        while (tempOffset > 6L && this.isDigit()) {
                                            this.pdfSource.seek(--tempOffset);
                                            ++length;
                                        }
                                        if (length > 0) {
                                            this.pdfSource.read();
                                            newOffset = this.pdfSource.getOffset();
                                        }
                                    }
                                }
                                Log.d((String)"PdfBoxAndroid", (String)("Fixed reference for xref stream " + xrefOffset + " -> " + newOffset));
                                objFound = true;
                                continue block1;
                            }
                            ++currentOffset;
                            this.pdfSource.read();
                        }
                    }
                    if (newOffset > -1L) {
                        this.bfSearchXRefStreamsOffsets.add(newOffset);
                    }
                    this.pdfSource.seek(xrefOffset + 5L);
                }
                this.pdfSource.read();
            }
            this.pdfSource.seek(originOffset);
        }
    }

    protected final COSDictionary rebuildTrailer() throws IOException {
        COSDictionary trailer = null;
        this.bfSearchForObjects();
        if (this.bfSearchCOSObjectKeyOffsets != null) {
            this.xrefTrailerResolver.nextXrefObj(0L, XrefTrailerResolver.XRefType.TABLE);
            for (COSObjectKey objectKey : this.bfSearchCOSObjectKeyOffsets.keySet()) {
                this.xrefTrailerResolver.setXRef(objectKey, this.bfSearchCOSObjectKeyOffsets.get(objectKey));
            }
            this.xrefTrailerResolver.setStartxref(0L);
            trailer = this.xrefTrailerResolver.getTrailer();
            this.getDocument().setTrailer(trailer);
            for (COSObjectKey key : this.bfSearchCOSObjectKeyOffsets.keySet()) {
                Long offset = this.bfSearchCOSObjectKeyOffsets.get(key);
                this.pdfSource.seek(offset);
                this.readObjectNumber();
                this.readGenerationNumber();
                this.readExpectedString(OBJ_MARKER, true);
                try {
                    COSDictionary dictionary = this.parseCOSDictionary();
                    if (dictionary == null) continue;
                    if (COSName.CATALOG.equals(dictionary.getCOSName(COSName.TYPE))) {
                        trailer.setItem(COSName.ROOT, (COSBase)this.document.getObjectFromPool(key));
                        continue;
                    }
                    if (!dictionary.containsKey(COSName.TITLE) && !dictionary.containsKey(COSName.AUTHOR) && !dictionary.containsKey(COSName.SUBJECT) && !dictionary.containsKey(COSName.KEYWORDS) && !dictionary.containsKey(COSName.CREATOR) && !dictionary.containsKey(COSName.PRODUCER) && !dictionary.containsKey(COSName.CREATION_DATE)) continue;
                    trailer.setItem(COSName.INFO, (COSBase)this.document.getObjectFromPool(key));
                }
                catch (IOException exception) {
                    Log.d((String)"PdfBoxAndroid", (String)("Skipped object " + key + ", either it's corrupt or not a dictionary"));
                }
            }
        }
        return trailer;
    }

    protected long parseStartXref() throws IOException {
        long startXref = -1L;
        if (this.isString(STARTXREF)) {
            this.readString();
            this.skipSpaces();
            startXref = this.readLong();
        }
        return startXref;
    }

    protected boolean parseTrailer() throws IOException {
        if (this.pdfSource.peek() != 116) {
            return false;
        }
        long currentOffset = this.pdfSource.getOffset();
        String nextLine = this.readLine();
        if (!nextLine.trim().equals("trailer")) {
            if (nextLine.startsWith("trailer")) {
                int len = "trailer".length();
                this.pdfSource.seek(currentOffset + (long)len);
            } else {
                return false;
            }
        }
        this.skipSpaces();
        COSDictionary parsedTrailer = this.parseCOSDictionary();
        this.xrefTrailerResolver.setTrailer(parsedTrailer);
        this.skipSpaces();
        return true;
    }

    protected boolean parsePDFHeader() throws IOException {
        return this.parseHeader(PDF_HEADER, PDF_DEFAULT_VERSION);
    }

    protected boolean parseFDFHeader() throws IOException {
        return this.parseHeader(FDF_HEADER, FDF_DEFAULT_VERSION);
    }

    private boolean parseHeader(String headerMarker, String defaultVersion) throws IOException {
        String header = this.readLine();
        if (!header.contains(headerMarker)) {
            header = this.readLine();
            while (!(header.contains(headerMarker) || header.length() > 0 && Character.isDigit(header.charAt(0)))) {
                header = this.readLine();
            }
        }
        if (!header.contains(headerMarker)) {
            this.pdfSource.seek(0L);
            return false;
        }
        int headerStart = header.indexOf(headerMarker);
        if (headerStart > 0) {
            header = header.substring(headerStart, header.length());
        }
        if (header.startsWith(headerMarker) && !header.matches(headerMarker + "\\d.\\d")) {
            if (header.length() < headerMarker.length() + 3) {
                header = headerMarker + defaultVersion;
                Log.d((String)"PdfBoxAndroid", (String)("No version found, set to " + defaultVersion + " as default."));
            }
        } else {
            String headerGarbage = header.substring(headerMarker.length() + 3, header.length()) + "\n";
            header = header.substring(0, headerMarker.length() + 3);
            this.pdfSource.unread(headerGarbage.getBytes("ISO-8859-1"));
        }
        float headerVersion = -1.0f;
        try {
            String[] headerParts = header.split("-");
            if (headerParts.length == 2) {
                headerVersion = Float.parseFloat(headerParts[1]);
            }
        }
        catch (NumberFormatException exception) {
            Log.d((String)"PdfBoxAndroid", (String)"Can't parse the header version.", (Throwable)exception);
        }
        if (headerVersion < 0.0f) {
            throw new IOException("Error getting header version: " + header);
        }
        this.document.setVersion(headerVersion);
        this.pdfSource.seek(0L);
        return true;
    }

    protected boolean parseXrefTable(long startByteOffset) throws IOException {
        if (this.pdfSource.peek() != 120) {
            return false;
        }
        String xref = this.readString();
        if (!xref.trim().equals("xref")) {
            return false;
        }
        String str = this.readString();
        byte[] b = str.getBytes("ISO-8859-1");
        this.pdfSource.unread(b, 0, b.length);
        this.xrefTrailerResolver.nextXrefObj(startByteOffset, XrefTrailerResolver.XRefType.TABLE);
        if (str.startsWith("trailer")) {
            Log.w((String)"PdfBoxAndroid", (String)"skipping empty xref table");
            return false;
        }
        do {
            long currObjID = this.readObjectNumber();
            long count = this.readLong();
            this.skipSpaces();
            int i = 0;
            while ((long)i < count && !this.pdfSource.isEOF() && !this.isEndOfName((char)this.pdfSource.peek()) && this.pdfSource.peek() != 116) {
                String currentLine = this.readLine();
                String[] splitString = currentLine.split("\\s");
                if (splitString.length < 3) {
                    Log.w((String)"PdfBoxAndroid", (String)("invalid xref line: " + currentLine));
                    break;
                }
                if (splitString[splitString.length - 1].equals("n")) {
                    try {
                        int currOffset = Integer.parseInt(splitString[0]);
                        int currGenID = Integer.parseInt(splitString[1]);
                        COSObjectKey objKey = new COSObjectKey(currObjID, currGenID);
                        this.xrefTrailerResolver.setXRef(objKey, currOffset);
                    }
                    catch (NumberFormatException e) {
                        throw new IOException(e);
                    }
                } else if (!splitString[2].equals("f")) {
                    throw new IOException("Corrupt XRefTable Entry - ObjID:" + currObjID);
                }
                ++currObjID;
                this.skipSpaces();
                ++i;
            }
            this.skipSpaces();
        } while (this.isDigit());
        return true;
    }

    public void parseXrefStream(COSStream stream, long objByteOffset, boolean isStandalone) throws IOException {
        if (isStandalone) {
            this.xrefTrailerResolver.nextXrefObj(objByteOffset, XrefTrailerResolver.XRefType.STREAM);
            this.xrefTrailerResolver.setTrailer(stream);
        }
        PDFXrefStreamParser parser = new PDFXrefStreamParser(stream, this.document, this.xrefTrailerResolver);
        parser.parse();
        parser.close();
    }

    public COSDocument getDocument() throws IOException {
        if (this.document == null) {
            throw new IOException("You must call parse() before calling getDocument()");
        }
        return this.document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    File createTmpFile(InputStream input) throws IOException {
        File file;
        FileOutputStream fos = null;
        try {
            File tmpFile = File.createTempFile(TMP_FILE_PREFIX, ".pdf");
            fos = new FileOutputStream(tmpFile);
            IOUtils.copy(input, fos);
            file = tmpFile;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly(input);
        IOUtils.closeQuietly(fos);
        return file;
    }
}

