/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.multipdf;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.COSStreamArray;
import org.apache.pdfbox.pdmodel.common.PDStream;

class PDFCloneUtility {
    private final PDDocument destination;
    private final Map<Object, COSBase> clonedVersion = new HashMap<Object, COSBase>();

    public PDFCloneUtility(PDDocument dest) {
        this.destination = dest;
    }

    public PDDocument getDestination() {
        return this.destination;
    }

    public COSBase cloneForNewDocument(Object base) throws IOException {
        if (base == null) {
            return null;
        }
        COSBase retval = this.clonedVersion.get(base);
        if (retval == null) {
            if (base instanceof List) {
                COSArray array = new COSArray();
                List list = (List)base;
                for (Object obj : list) {
                    array.add(this.cloneForNewDocument(obj));
                }
                retval = array;
            } else if (base instanceof COSObjectable && !(base instanceof COSBase)) {
                retval = this.cloneForNewDocument(((COSObjectable)base).getCOSObject());
                this.clonedVersion.put(base, retval);
            } else if (base instanceof COSObject) {
                COSObject object = (COSObject)base;
                retval = this.cloneForNewDocument(object.getObject());
                this.clonedVersion.put(base, retval);
            } else if (base instanceof COSArray) {
                COSArray newArray = new COSArray();
                COSArray array = (COSArray)base;
                for (int i = 0; i < array.size(); ++i) {
                    newArray.add(this.cloneForNewDocument(array.get(i)));
                }
                retval = newArray;
                this.clonedVersion.put(base, retval);
            } else if (base instanceof COSStreamArray) {
                COSStreamArray originalStream = (COSStreamArray)base;
                if (originalStream.size() > 0) {
                    throw new IllegalStateException("Cannot close stream array with items next to the streams.");
                }
                COSArray array = new COSArray();
                for (int i = 0; i < originalStream.getStreamCount(); ++i) {
                    COSBase base2 = originalStream.get(i);
                    COSBase cloneForNewDocument = this.cloneForNewDocument(base2);
                    array.add(cloneForNewDocument);
                }
                retval = new COSStreamArray(array);
                this.clonedVersion.put(base, retval);
            } else if (base instanceof COSStream) {
                COSStream originalStream = (COSStream)base;
                PDStream stream = new PDStream(this.destination, originalStream.getFilteredStream(), true);
                this.clonedVersion.put(base, stream.getStream());
                for (Map.Entry<COSName, COSBase> entry : originalStream.entrySet()) {
                    stream.getStream().setItem(entry.getKey(), this.cloneForNewDocument(entry.getValue()));
                }
                retval = stream.getStream();
            } else if (base instanceof COSDictionary) {
                COSDictionary dic = (COSDictionary)base;
                retval = new COSDictionary();
                this.clonedVersion.put(base, retval);
                for (Map.Entry<COSName, COSBase> entry : dic.entrySet()) {
                    ((COSDictionary)retval).setItem(entry.getKey(), this.cloneForNewDocument(entry.getValue()));
                }
            } else {
                retval = (COSBase)base;
            }
        }
        this.clonedVersion.put(base, retval);
        return retval;
    }

    public void cloneMerge(COSObjectable base, COSObjectable target) throws IOException {
        if (base == null) {
            return;
        }
        COSBase retval = this.clonedVersion.get(base);
        if (retval != null) {
            return;
        }
        if (base instanceof List) {
            COSArray array = new COSArray();
            List list = (List)((Object)base);
            for (Object obj : list) {
                array.add(this.cloneForNewDocument(obj));
            }
            ((List)((Object)target)).add(array);
        } else if (base instanceof COSObjectable && !(base instanceof COSBase)) {
            this.cloneMerge(base.getCOSObject(), target.getCOSObject());
            this.clonedVersion.put(base, retval);
        } else if (base instanceof COSObject) {
            if (target instanceof COSObject) {
                this.cloneMerge(((COSObject)base).getObject(), ((COSObject)target).getObject());
            } else if (target instanceof COSDictionary) {
                this.cloneMerge(((COSObject)base).getObject(), target);
            }
            this.clonedVersion.put(base, retval);
        } else if (base instanceof COSArray) {
            COSArray array = (COSArray)base;
            for (int i = 0; i < array.size(); ++i) {
                ((COSArray)target).add(this.cloneForNewDocument(array.get(i)));
            }
            this.clonedVersion.put(base, retval);
        } else if (base instanceof COSStream) {
            COSStream originalStream = (COSStream)base;
            PDStream stream = new PDStream(this.destination, originalStream.getFilteredStream(), true);
            this.clonedVersion.put(base, stream.getStream());
            for (Map.Entry<COSName, COSBase> entry : originalStream.entrySet()) {
                stream.getStream().setItem(entry.getKey(), this.cloneForNewDocument(entry.getValue()));
            }
            retval = stream.getStream();
            target = retval;
        } else if (base instanceof COSDictionary) {
            COSDictionary dic = (COSDictionary)base;
            this.clonedVersion.put(base, retval);
            for (Map.Entry<COSName, COSBase> entry : dic.entrySet()) {
                COSName key = entry.getKey();
                COSBase value = entry.getValue();
                if (((COSDictionary)target).getItem(key) != null) {
                    this.cloneMerge(value, ((COSDictionary)target).getItem(key));
                    continue;
                }
                ((COSDictionary)target).setItem(key, this.cloneForNewDocument(value));
            }
        } else {
            retval = (COSBase)base;
        }
        this.clonedVersion.put(base, retval);
    }
}

