/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.cos;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.ICOSVisitor;

public class COSFloat
extends COSNumber {
    private BigDecimal value;
    private String valueAsString;

    public COSFloat(float aFloat) {
        this.value = new BigDecimal(String.valueOf(aFloat));
        this.valueAsString = COSFloat.removeNullDigits(this.value.toPlainString());
    }

    public COSFloat(String aFloat) throws IOException {
        try {
            this.valueAsString = aFloat;
            this.value = new BigDecimal(this.valueAsString);
        }
        catch (NumberFormatException e) {
            throw new IOException("Error expected floating point number actual='" + aFloat + "'", e);
        }
    }

    private static String removeNullDigits(String plainStringValue) {
        if (plainStringValue.indexOf(46) > -1 && !plainStringValue.endsWith(".0")) {
            while (plainStringValue.endsWith("0") && !plainStringValue.endsWith(".0")) {
                plainStringValue = plainStringValue.substring(0, plainStringValue.length() - 1);
            }
        }
        return plainStringValue;
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    public boolean equals(Object o) {
        return o instanceof COSFloat && Float.floatToIntBits(((COSFloat)o).value.floatValue()) == Float.floatToIntBits(this.value.floatValue());
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return "COSFloat{" + this.valueAsString + "}";
    }

    @Override
    public Object accept(ICOSVisitor visitor) throws IOException {
        return visitor.visitFromFloat(this);
    }

    public void writePDF(OutputStream output) throws IOException {
        output.write(this.valueAsString.getBytes("ISO-8859-1"));
    }
}

