/*
 * Decompiled with CFR 0.152.
 */
package org.apache.javax.imageio.stream;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.javax.imageio.stream.MemoryCache;

public class MemoryCacheImageOutputStream {
    private OutputStream stream;
    private MemoryCache cache = new MemoryCache();
    protected long streamPos;
    protected int bitOffset;
    protected long flushedPos = 0L;

    public MemoryCacheImageOutputStream(OutputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("stream == null!");
        }
        this.stream = stream;
    }

    public void writeBits(long bits, int numBits) throws IOException {
        if (numBits < 0 || numBits > 64) {
            throw new IllegalArgumentException("Bad value for numBits!");
        }
        if (numBits == 0) {
            return;
        }
        if (this.streamPos > 0L || this.bitOffset > 0) {
            int offset = this.bitOffset;
            int partialByte = this.read();
            if (partialByte != -1) {
                this.seek(this.streamPos - 1L);
            } else {
                partialByte = 0;
            }
            if (numBits + offset < 8) {
                int shift = 8 - (offset + numBits);
                int mask = -1 >>> 32 - numBits;
                partialByte &= ~(mask << shift);
                partialByte = (int)((long)partialByte | (bits & (long)mask) << shift);
                this.write(partialByte);
                this.seek(this.streamPos - 1L);
                this.bitOffset = offset + numBits;
                numBits = 0;
            } else {
                int num = 8 - offset;
                int mask = -1 >>> 32 - num;
                partialByte &= ~mask;
                partialByte = (int)((long)partialByte | bits >> numBits - num & (long)mask);
                this.write(partialByte);
                numBits -= num;
            }
        }
    }

    public int read() throws IOException {
        this.bitOffset = 0;
        int val = this.cache.read(this.streamPos);
        if (val != -1) {
            ++this.streamPos;
        }
        return val;
    }

    public void seek(long pos) throws IOException {
        if (pos < this.flushedPos) {
            throw new IndexOutOfBoundsException("pos < flushedPos!");
        }
        this.streamPos = pos;
        this.bitOffset = 0;
    }

    public void write(int b) throws IOException {
        this.flushBits();
        this.cache.write(b, this.streamPos);
        ++this.streamPos;
    }

    protected final void flushBits() throws IOException {
        if (this.bitOffset != 0) {
            int offset = this.bitOffset;
            int partialByte = this.read();
            if (partialByte < 0) {
                partialByte = 0;
                this.bitOffset = 0;
            } else {
                this.seek(this.streamPos - 1L);
                partialByte &= -1 << 8 - offset;
            }
            this.write(partialByte);
        }
    }

    public void flush() throws IOException {
        this.flushBefore(this.streamPos);
    }

    public void flushBefore(long pos) throws IOException {
        if (pos < this.flushedPos) {
            throw new IndexOutOfBoundsException("pos < flushedPos!");
        }
        if (pos > this.streamPos) {
            throw new IndexOutOfBoundsException("pos > getStreamPosition()!");
        }
        this.flushedPos = pos;
    }
}

