/*
 * Decompiled with CFR 0.152.
 */
package org.apache.javax.imageio.stream;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.javax.imageio.stream.MemoryCache;

public class MemoryCacheImageInputStream {
    protected long streamPos;
    protected int bitOffset;
    protected long flushedPos = 0L;
    private InputStream stream;
    private MemoryCache cache = new MemoryCache();

    public MemoryCacheImageInputStream(InputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("stream == null!");
        }
        this.stream = stream;
    }

    public long readBits(int numBits) throws IOException {
        int bitsToRead;
        if (numBits < 0 || numBits > 64) {
            throw new IllegalArgumentException();
        }
        if (numBits == 0) {
            return 0L;
        }
        int newBitOffset = this.bitOffset + numBits & 7;
        long accum = 0L;
        for (bitsToRead = numBits + this.bitOffset; bitsToRead > 0; bitsToRead -= 8) {
            int val = this.read();
            if (val == -1) {
                throw new EOFException();
            }
            accum <<= 8;
            accum |= (long)val;
        }
        if (newBitOffset != 0) {
            this.seek(this.streamPos - 1L);
        }
        this.bitOffset = newBitOffset;
        accum >>>= -bitsToRead;
        return accum &= -1L >>> 64 - numBits;
    }

    public void seek(long pos) throws IOException {
        if (pos < this.flushedPos) {
            throw new IndexOutOfBoundsException("pos < flushedPos!");
        }
        this.streamPos = pos;
        this.bitOffset = 0;
    }

    public int read() throws IOException {
        this.bitOffset = 0;
        long pos = this.cache.loadFromStream(this.stream, this.streamPos + 1L);
        if (pos >= this.streamPos + 1L) {
            return this.cache.read(this.streamPos++);
        }
        return -1;
    }
}

