/*
 * Decompiled with CFR 0.152.
 */
package org.apache.javax.imageio.stream;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class MemoryCache {
    private static final int BUFFER_LENGTH = 8192;
    private ArrayList cache = new ArrayList();
    private long cacheStart = 0L;
    private long length = 0L;

    private byte[] getCacheBlock(long blockNum) throws IOException {
        long blockOffset = blockNum - this.cacheStart;
        if (blockOffset > Integer.MAX_VALUE) {
            throw new IOException("Cache addressing limit exceeded!");
        }
        return (byte[])this.cache.get((int)blockOffset);
    }

    public long loadFromStream(InputStream stream, long pos) throws IOException {
        if (pos < this.length) {
            return pos;
        }
        int offset = (int)(this.length % 8192L);
        byte[] buf = null;
        long len = pos - this.length;
        if (offset != 0) {
            buf = this.getCacheBlock(this.length / 8192L);
        }
        while (len > 0L) {
            if (buf == null) {
                try {
                    buf = new byte[8192];
                }
                catch (OutOfMemoryError e) {
                    throw new IOException("No memory left for cache!");
                }
                offset = 0;
            }
            int left = 8192 - offset;
            int nbytes = (int)Math.min(len, (long)left);
            if ((nbytes = stream.read(buf, offset, nbytes)) == -1) {
                return this.length;
            }
            if (offset == 0) {
                this.cache.add(buf);
            }
            len -= (long)nbytes;
            this.length += (long)nbytes;
            if ((offset += nbytes) < 8192) continue;
            buf = null;
        }
        return pos;
    }

    public int read(long pos) throws IOException {
        if (pos >= this.length) {
            return -1;
        }
        byte[] buf = this.getCacheBlock(pos / 8192L);
        if (buf == null) {
            return -1;
        }
        return buf[(int)(pos % 8192L)] & 0xFF;
    }

    public void write(int b, long pos) throws IOException {
        if (pos < 0L) {
            throw new ArrayIndexOutOfBoundsException("pos < 0");
        }
        if (pos >= this.length) {
            this.pad(pos);
            this.length = pos + 1L;
        }
        byte[] buf = this.getCacheBlock(pos / 8192L);
        int offset = (int)(pos % 8192L);
        buf[offset] = (byte)b;
    }

    private void pad(long pos) throws IOException {
        long currIndex = this.cacheStart + (long)this.cache.size() - 1L;
        long lastIndex = pos / 8192L;
        long numNewBuffers = lastIndex - currIndex;
        for (long i = 0L; i < numNewBuffers; ++i) {
            try {
                this.cache.add(new byte[8192]);
                continue;
            }
            catch (OutOfMemoryError e) {
                throw new IOException("No memory left for cache!");
            }
        }
    }
}

