/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.util.autodetect;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.fontbox.util.autodetect.AndroidFontDirFinder;
import org.apache.fontbox.util.autodetect.FontDirFinder;
import org.apache.fontbox.util.autodetect.UnixFontDirFinder;

public class FontFileFinder {
    private FontDirFinder fontDirFinder = null;

    private FontDirFinder determineDirFinder() {
        if (System.getProperty("java.vendor").equals("The Android Project")) {
            return new AndroidFontDirFinder();
        }
        return new UnixFontDirFinder();
    }

    public List<URI> find() {
        if (this.fontDirFinder == null) {
            this.fontDirFinder = this.determineDirFinder();
        }
        List<File> fontDirs = this.fontDirFinder.find();
        ArrayList<URI> results = new ArrayList<URI>();
        for (File dir : fontDirs) {
            this.walk(dir, results);
        }
        return results;
    }

    public List<URI> find(String dir) {
        ArrayList<URI> results = new ArrayList<URI>();
        File directory = new File(dir);
        if (directory.isDirectory()) {
            this.walk(directory, results);
        }
        return results;
    }

    private void walk(File directory, List<URI> results) {
        File[] filelist;
        if (directory.isDirectory() && (filelist = directory.listFiles()) != null) {
            for (File file : filelist) {
                if (file.isDirectory()) {
                    if (file.getName().startsWith(".")) continue;
                    this.walk(file, results);
                    continue;
                }
                if (!this.checkFontfile(file)) continue;
                results.add(file.toURI());
            }
        }
    }

    private boolean checkFontfile(File file) {
        String name = file.getName().toLowerCase();
        return name.endsWith(".ttf") || name.endsWith(".otf") || name.endsWith(".pfb") || name.endsWith(".ttc");
    }
}

