/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.ttf;

import android.graphics.Path;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.fontbox.encoding.Encoding;
import org.apache.fontbox.ttf.CmapSubtable;
import org.apache.fontbox.ttf.CmapTable;
import org.apache.fontbox.ttf.GlyphData;
import org.apache.fontbox.ttf.GlyphTable;
import org.apache.fontbox.ttf.HeaderTable;
import org.apache.fontbox.ttf.HorizontalHeaderTable;
import org.apache.fontbox.ttf.HorizontalMetricsTable;
import org.apache.fontbox.ttf.IndexToLocationTable;
import org.apache.fontbox.ttf.MaximumProfileTable;
import org.apache.fontbox.ttf.NamingTable;
import org.apache.fontbox.ttf.OS2WindowsMetricsTable;
import org.apache.fontbox.ttf.PostScriptTable;
import org.apache.fontbox.ttf.TTFDataStream;
import org.apache.fontbox.ttf.TTFTable;
import org.apache.fontbox.ttf.Type1Equivalent;
import org.apache.fontbox.util.BoundingBox;
import org.apache.pdfbox.util.awt.AffineTransform;

public class TrueTypeFont
implements Type1Equivalent {
    private float version;
    private int numberOfGlyphs = -1;
    private int unitsPerEm = -1;
    protected Map<String, TTFTable> tables = new HashMap<String, TTFTable>();
    private TTFDataStream data;
    private Map<String, Integer> postScriptNames;

    TrueTypeFont(TTFDataStream fontData) {
        this.data = fontData;
    }

    public void close() throws IOException {
        this.data.close();
    }

    public float getVersion() {
        return this.version;
    }

    void setVersion(float versionValue) {
        this.version = versionValue;
    }

    void addTable(TTFTable table) {
        this.tables.put(table.getTag(), table);
    }

    public Collection<TTFTable> getTables() {
        return this.tables.values();
    }

    public Map<String, TTFTable> getTableMap() {
        return this.tables;
    }

    public synchronized byte[] getTableBytes(TTFTable table) throws IOException {
        long currentPosition = this.data.getCurrentPosition();
        this.data.seek(table.getOffset());
        byte[] bytes = this.data.read((int)table.getLength());
        this.data.seek(currentPosition);
        return bytes;
    }

    public synchronized NamingTable getNaming() throws IOException {
        NamingTable naming = (NamingTable)this.tables.get("name");
        if (naming != null && !naming.getInitialized()) {
            this.readTable(naming);
        }
        return naming;
    }

    public synchronized PostScriptTable getPostScript() throws IOException {
        PostScriptTable postscript = (PostScriptTable)this.tables.get("post");
        if (postscript != null && !postscript.getInitialized()) {
            this.readTable(postscript);
        }
        return postscript;
    }

    public synchronized OS2WindowsMetricsTable getOS2Windows() throws IOException {
        OS2WindowsMetricsTable os2WindowsMetrics = (OS2WindowsMetricsTable)this.tables.get("OS/2");
        if (os2WindowsMetrics != null && !os2WindowsMetrics.getInitialized()) {
            this.readTable(os2WindowsMetrics);
        }
        return os2WindowsMetrics;
    }

    public synchronized MaximumProfileTable getMaximumProfile() throws IOException {
        MaximumProfileTable maximumProfile = (MaximumProfileTable)this.tables.get("maxp");
        if (maximumProfile != null && !maximumProfile.getInitialized()) {
            this.readTable(maximumProfile);
        }
        return maximumProfile;
    }

    public synchronized HeaderTable getHeader() throws IOException {
        HeaderTable header = (HeaderTable)this.tables.get("head");
        if (header != null && !header.getInitialized()) {
            this.readTable(header);
        }
        return header;
    }

    public synchronized HorizontalHeaderTable getHorizontalHeader() throws IOException {
        HorizontalHeaderTable horizontalHeader = (HorizontalHeaderTable)this.tables.get("hhea");
        if (horizontalHeader != null && !horizontalHeader.getInitialized()) {
            this.readTable(horizontalHeader);
        }
        return horizontalHeader;
    }

    public synchronized HorizontalMetricsTable getHorizontalMetrics() throws IOException {
        HorizontalMetricsTable horizontalMetrics = (HorizontalMetricsTable)this.tables.get("hmtx");
        if (horizontalMetrics != null && !horizontalMetrics.getInitialized()) {
            this.readTable(horizontalMetrics);
        }
        return horizontalMetrics;
    }

    public synchronized IndexToLocationTable getIndexToLocation() throws IOException {
        IndexToLocationTable indexToLocation = (IndexToLocationTable)this.tables.get("loca");
        if (indexToLocation != null && !indexToLocation.getInitialized()) {
            this.readTable(indexToLocation);
        }
        return indexToLocation;
    }

    public synchronized GlyphTable getGlyph() throws IOException {
        GlyphTable glyph = (GlyphTable)this.tables.get("glyf");
        if (glyph != null && !glyph.getInitialized()) {
            this.readTable(glyph);
        }
        return glyph;
    }

    public synchronized CmapTable getCmap() throws IOException {
        CmapTable cmap = (CmapTable)this.tables.get("cmap");
        if (cmap != null && !cmap.getInitialized()) {
            this.readTable(cmap);
        }
        return cmap;
    }

    public InputStream getOriginalData() throws IOException {
        return this.data.getOriginalData();
    }

    void readTable(TTFTable table) throws IOException {
        long currentPosition = this.data.getCurrentPosition();
        this.data.seek(table.getOffset());
        table.read(this, this.data);
        this.data.seek(currentPosition);
    }

    public int getNumberOfGlyphs() throws IOException {
        if (this.numberOfGlyphs == -1) {
            MaximumProfileTable maximumProfile = this.getMaximumProfile();
            this.numberOfGlyphs = maximumProfile != null ? maximumProfile.getNumGlyphs() : 0;
        }
        return this.numberOfGlyphs;
    }

    public int getUnitsPerEm() throws IOException {
        if (this.unitsPerEm == -1) {
            HeaderTable header = this.getHeader();
            this.unitsPerEm = header != null ? header.getUnitsPerEm() : 0;
        }
        return this.unitsPerEm;
    }

    public int getAdvanceWidth(int gid) throws IOException {
        HorizontalMetricsTable hmtx = this.getHorizontalMetrics();
        if (hmtx != null) {
            return hmtx.getAdvanceWidth(gid);
        }
        return 250;
    }

    @Override
    public String getName() throws IOException {
        if (this.getNaming() != null) {
            return this.getNaming().getPostScriptName();
        }
        return null;
    }

    private synchronized void readPostScriptNames() throws IOException {
        if (this.postScriptNames == null) {
            String[] names;
            this.postScriptNames = new HashMap<String, Integer>();
            if (this.getPostScript() != null && (names = this.getPostScript().getGlyphNames()) != null) {
                for (int i = 0; i < names.length; ++i) {
                    this.postScriptNames.put(names[i], i);
                }
            }
        }
    }

    public CmapSubtable getUnicodeCmap() throws IOException {
        return this.getUnicodeCmap(true);
    }

    public CmapSubtable getUnicodeCmap(boolean isStrict) throws IOException {
        CmapTable cmapTable = this.getCmap();
        if (cmapTable == null) {
            return null;
        }
        CmapSubtable cmap = cmapTable.getSubtable(0, 4);
        if (cmap == null) {
            cmap = cmapTable.getSubtable(0, 3);
        }
        if (cmap == null) {
            cmap = cmapTable.getSubtable(3, 1);
        }
        if (cmap == null) {
            cmap = cmapTable.getSubtable(3, 0);
        }
        if (cmap == null) {
            if (isStrict) {
                throw new IOException("The TrueType font does not contain a Unicode cmap");
            }
            cmap = cmapTable.getCmaps()[0];
        }
        return cmap;
    }

    public int nameToGID(String name) throws IOException {
        this.readPostScriptNames();
        Integer gid = this.postScriptNames.get(name);
        if (gid != null && gid > 0 && gid < this.getMaximumProfile().getNumGlyphs()) {
            return gid;
        }
        int uni = this.parseUniName(name);
        if (uni > -1) {
            CmapSubtable cmap = this.getUnicodeCmap(false);
            return cmap.getGlyphId(uni);
        }
        return 0;
    }

    private int parseUniName(String name) throws IOException {
        if (name.startsWith("uni") && name.length() == 7) {
            int nameLength = name.length();
            StringBuilder uniStr = new StringBuilder();
            try {
                int chPos = 3;
                while (chPos + 4 <= nameLength) {
                    int codePoint = Integer.parseInt(name.substring(chPos, chPos + 4), 16);
                    if (codePoint <= 55295 || codePoint >= 57344) {
                        uniStr.append((char)codePoint);
                    }
                    chPos += 4;
                }
                String unicode = uniStr.toString();
                if (unicode.length() == 0) {
                    return -1;
                }
                return unicode.codePointAt(0);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return -1;
    }

    @Override
    public Path getPath(String name) throws IOException {
        GlyphData glyph;
        this.readPostScriptNames();
        int gid = this.nameToGID(name);
        if (gid < 0 || gid >= this.getMaximumProfile().getNumGlyphs()) {
            gid = 0;
        }
        if ((glyph = this.getGlyph().getGlyph(gid)) == null) {
            return new Path();
        }
        Path path = glyph.getPath();
        float scale = 1000.0f / (float)this.getUnitsPerEm();
        AffineTransform atScale = AffineTransform.getScaleInstance(scale, scale);
        path.transform(atScale.toMatrix());
        return path;
    }

    @Override
    public float getWidth(String name) throws IOException {
        Integer gid = this.nameToGID(name);
        int width = this.getAdvanceWidth(gid);
        int unitsPerEM = this.getUnitsPerEm();
        if (unitsPerEM != 1000) {
            width = (int)((float)width * (1000.0f / (float)unitsPerEM));
        }
        return width;
    }

    @Override
    public boolean hasGlyph(String name) throws IOException {
        return this.nameToGID(name) != 0;
    }

    @Override
    public Encoding getEncoding() {
        return null;
    }

    @Override
    public BoundingBox getFontBBox() throws IOException {
        short xMin = this.getHeader().getXMin();
        short xMax = this.getHeader().getXMax();
        short yMin = this.getHeader().getYMin();
        short yMax = this.getHeader().getYMax();
        float scale = 1000.0f / (float)this.getUnitsPerEm();
        return new BoundingBox((float)xMin * scale, (float)yMin * scale, (float)xMax * scale, (float)yMax * scale);
    }

    public String toString() {
        try {
            if (this.getNaming() != null) {
                return this.getNaming().getPostScriptName();
            }
            return "(null)";
        }
        catch (IOException e) {
            return "(null - " + e.getMessage() + ")";
        }
    }
}

