/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.cli.BaseCommand;
import org.apache.parquet.cli.util.Codecs;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.rewrite.MaskMode;
import org.apache.parquet.hadoop.rewrite.ParquetRewriter;
import org.apache.parquet.hadoop.rewrite.RewriteOptions;
import org.slf4j.Logger;

@Parameters(commandDescription="Rewrite one or more Parquet files to a new Parquet file")
public class RewriteCommand
extends BaseCommand {
    @Parameter(names={"-i", "--input"}, description="<comma-separated text of input parquet file paths>", required=true)
    List<String> inputs;
    @Parameter(names={"-o", "--output"}, description="<output parquet file path>", required=true)
    String output;
    @Parameter(names={"--overwrite"}, description="Overwrite the output file if it exists", required=false)
    boolean overwrite;
    @Parameter(names={"--mask-mode"}, description="<mask mode: nullify>", required=false)
    String maskMode;
    @Parameter(names={"--mask-columns"}, description="<columns to be replaced with masked value>", required=false)
    List<String> maskColumns;
    @Parameter(names={"--prune-columns"}, description="<columns to be removed>", required=false)
    List<String> pruneColumns;
    @Parameter(names={"-c", "--compression-codec"}, description="<new compression codec>", required=false)
    String codec;

    public RewriteCommand(Logger console) {
        super(console);
    }

    private RewriteOptions buildOptionsOrFail() throws IOException {
        Preconditions.checkArgument((this.inputs != null && !this.inputs.isEmpty() && this.output != null ? 1 : 0) != 0, (Object)"Both input and output parquet file paths are required.");
        ArrayList<Path> inputPaths = new ArrayList<Path>();
        for (String input : this.inputs) {
            inputPaths.add(new Path(input));
        }
        Path outputPath = new Path(this.output);
        RewriteOptions.Builder builder = new RewriteOptions.Builder(this.getConf(), inputPaths, outputPath);
        if (this.maskMode != null && this.maskMode.equals("nullify") && this.maskColumns != null && !this.maskColumns.isEmpty()) {
            HashMap<String, MaskMode> maskModeMap = new HashMap<String, MaskMode>();
            for (String maskColumn : this.maskColumns) {
                maskModeMap.put(maskColumn, MaskMode.NULLIFY);
            }
            builder.mask(maskModeMap);
        }
        if (this.pruneColumns != null && !this.pruneColumns.isEmpty()) {
            builder.prune(this.pruneColumns);
        }
        if (this.codec != null) {
            CompressionCodecName codecName = Codecs.parquetCodec(this.codec);
            builder.transform(codecName);
        }
        RewriteOptions options = builder.build();
        FileSystem outFS = outputPath.getFileSystem(this.getConf());
        if (this.overwrite && outFS.exists(outputPath)) {
            this.console.debug("Deleting output file {} (already exists)", (Object)outputPath);
            outFS.delete(outputPath);
        }
        return options;
    }

    @Override
    public int run() throws IOException {
        RewriteOptions options = this.buildOptionsOrFail();
        ParquetRewriter rewriter = new ParquetRewriter(options);
        rewriter.processBlocks();
        rewriter.close();
        return 0;
    }

    @Override
    public List<String> getExamples() {
        return Lists.newArrayList((Object[])new String[]{"# Rewrite one or more Parquet files to a new Parquet file", "-i input.parquet -o output.parquet --mask-mode nullify --mask-columns col1_name"});
    }
}

