/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.internal.Lists;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Set;
import org.apache.parquet.cli.BaseCommand;
import org.apache.parquet.cli.csv.AvroCSV;
import org.apache.parquet.cli.csv.CSVProperties;
import org.slf4j.Logger;

@Parameters(commandDescription="Build a schema from a CSV data sample")
public class CSVSchemaCommand
extends BaseCommand {
    @Parameter(description="<sample csv path>")
    List<String> samplePaths;
    @Parameter(names={"-o", "--output"}, description="Save schema avsc to path")
    String outputPath = null;
    @Parameter(names={"--class", "--record-name"}, required=true, description="A name or class for the result schema")
    String recordName = null;
    @Parameter(names={"--minimize"}, description="Minimize schema file size by eliminating white space")
    boolean minimize = false;
    @Parameter(names={"--delimiter"}, description="Delimiter character")
    String delimiter = ",";
    @Parameter(names={"--escape"}, description="Escape character")
    String escape = "\\";
    @Parameter(names={"--quote"}, description="Quote character")
    String quote = "\"";
    @Parameter(names={"--no-header"}, description="Don't use first line as CSV header")
    boolean noHeader = false;
    @Parameter(names={"--skip-lines"}, description="Lines to skip before CSV start")
    int linesToSkip = 0;
    @Parameter(names={"--charset"}, description="Character set name", hidden=true)
    String charsetName = Charset.defaultCharset().displayName();
    @Parameter(names={"--header"}, description="Line to use as a header. Must match the CSV settings.")
    String header;
    @Parameter(names={"--require"}, description="Do not allow null values for the given field")
    List<String> requiredFields;

    public CSVSchemaCommand(Logger console) {
        super(console);
    }

    @Override
    public int run() throws IOException {
        Preconditions.checkArgument((this.samplePaths != null && !this.samplePaths.isEmpty() ? 1 : 0) != 0, (Object)"Sample CSV path is required");
        Preconditions.checkArgument((this.samplePaths.size() == 1 ? 1 : 0) != 0, (Object)"Only one CSV sample can be given");
        if (this.header != null) {
            this.noHeader = true;
        }
        CSVProperties props = new CSVProperties.Builder().delimiter(this.delimiter).escape(this.escape).quote(this.quote).header(this.header).hasHeader(!this.noHeader).linesToSkip(this.linesToSkip).charset(this.charsetName).build();
        ImmutableSet required = ImmutableSet.of();
        if (this.requiredFields != null) {
            required = ImmutableSet.copyOf(this.requiredFields);
        }
        String sampleSchema = AvroCSV.inferNullableSchema(this.recordName, this.open(this.samplePaths.get(0)), props, (Set<String>)required).toString(!this.minimize);
        this.output(sampleSchema, this.console, this.outputPath);
        return 0;
    }

    @Override
    public List<String> getExamples() {
        return Lists.newArrayList((Object[])new String[]{"# Print the schema for samples.csv to standard out:", "samples.csv --record-name Sample", "# Write schema to sample.avsc:", "samples.csv -o sample.avsc --record-name Sample"});
    }
}

