/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.avro.AvroParquetWriter;
import org.apache.parquet.cli.BaseCommand;
import org.apache.parquet.cli.csv.AvroCSV;
import org.apache.parquet.cli.csv.AvroCSVReader;
import org.apache.parquet.cli.csv.CSVProperties;
import org.apache.parquet.cli.util.Codecs;
import org.apache.parquet.cli.util.Schemas;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.slf4j.Logger;

@Parameters(commandDescription="Create a file from CSV data")
public class ConvertCSVCommand
extends BaseCommand {
    @Parameter(description="<csv path>")
    List<String> targets;
    @Parameter(names={"-o", "--output"}, description="Output file path", required=true)
    String outputPath = null;
    @Parameter(names={"-2", "--format-version-2", "--writer-version-2"}, description="Use Parquet format version 2", hidden=true)
    boolean v2 = false;
    @Parameter(names={"--delimiter"}, description="Delimiter character")
    String delimiter = ",";
    @Parameter(names={"--escape"}, description="Escape character")
    String escape = "\\";
    @Parameter(names={"--quote"}, description="Quote character")
    String quote = "\"";
    @Parameter(names={"--no-header"}, description="Don't use first line as CSV header")
    boolean noHeader = false;
    @Parameter(names={"--skip-lines"}, description="Lines to skip before CSV start")
    int linesToSkip = 0;
    @Parameter(names={"--charset"}, description="Character set name", hidden=true)
    String charsetName = Charset.defaultCharset().displayName();
    @Parameter(names={"--header"}, description="Line to use as a header. Must match the CSV settings.")
    String header;
    @Parameter(names={"--require"}, description="Do not allow null values for the given field")
    List<String> requiredFields;
    @Parameter(names={"-s", "--schema"}, description="The file containing the Avro schema.")
    String avroSchemaFile;
    @Parameter(names={"--compression-codec"}, description="A compression codec name.")
    String compressionCodecName = "GZIP";
    @Parameter(names={"--row-group-size"}, description="Target row group size")
    int rowGroupSize = 0x8000000;
    @Parameter(names={"--page-size"}, description="Target page size")
    int pageSize = 0x100000;
    @Parameter(names={"--dictionary-size"}, description="Max dictionary page size")
    int dictionaryPageSize = 0x100000;
    @Parameter(names={"--overwrite"}, description="Remove any data already in the target view or dataset")
    boolean overwrite = false;

    public ConvertCSVCommand(Logger console) {
        super(console);
    }

    @Override
    public int run() throws IOException {
        Schema csvSchema;
        Preconditions.checkArgument((this.targets != null && this.targets.size() == 1 ? 1 : 0) != 0, (Object)"CSV path is required.");
        if (this.header != null) {
            this.noHeader = true;
        }
        CSVProperties props = new CSVProperties.Builder().delimiter(this.delimiter).escape(this.escape).quote(this.quote).header(this.header).hasHeader(!this.noHeader).linesToSkip(this.linesToSkip).charset(this.charsetName).build();
        String source = this.targets.get(0);
        if (this.avroSchemaFile != null) {
            csvSchema = Schemas.fromAvsc(this.open(this.avroSchemaFile));
        } else {
            String filename;
            ImmutableSet required = ImmutableSet.of();
            if (this.requiredFields != null) {
                required = ImmutableSet.copyOf(this.requiredFields);
            }
            String recordName = (filename = new File(source).getName()).contains(".") ? filename.substring(0, filename.indexOf(".")) : filename;
            csvSchema = AvroCSV.inferNullableSchema(recordName, this.open(source), props, (Set<String>)required);
        }
        long count = 0L;
        try (AvroCSVReader<GenericData.Record> reader = new AvroCSVReader<GenericData.Record>(this.open(source), props, csvSchema, GenericData.Record.class, true);){
            CompressionCodecName codec = Codecs.parquetCodec(this.compressionCodecName);
            try (ParquetWriter writer = ((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)AvroParquetWriter.builder((Path)this.qualifiedPath(this.outputPath)).withWriterVersion(this.v2 ? ParquetProperties.WriterVersion.PARQUET_2_0 : ParquetProperties.WriterVersion.PARQUET_1_0)).withWriteMode(this.overwrite ? ParquetFileWriter.Mode.OVERWRITE : ParquetFileWriter.Mode.CREATE)).withCompressionCodec(codec)).withDictionaryEncoding(true)).withDictionaryPageSize(this.dictionaryPageSize)).withPageSize(this.pageSize)).withRowGroupSize(this.rowGroupSize)).withDataModel(GenericData.get()).withConf(this.getConf())).withSchema(csvSchema).build();){
                for (GenericData.Record record : reader) {
                    writer.write((Object)record);
                }
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Failed on record " + count, e);
            }
        }
        return 0;
    }

    @Override
    public List<String> getExamples() {
        return Lists.newArrayList((Object[])new String[]{"# Create a Parquet file from a CSV file", "sample.csv sample.parquet --schema schema.avsc", "# Create a Parquet file in HDFS from local CSV", "path/to/sample.csv hdfs:/user/me/sample.parquet --schema schema.avsc", "# Create an Avro file from CSV data in S3", "s3:/data/path/sample.csv sample.avro --format avro --schema s3:/schemas/schema.avsc"});
    }
}

