/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.parquet.cli.BaseCommand;
import org.apache.parquet.cli.util.Expressions;
import org.slf4j.Logger;

@Parameters(commandDescription="Scan all records from a file")
public class ScanCommand
extends BaseCommand {
    @Parameter(description="<file>")
    String sourceFile;
    @Parameter(names={"-c", "--column", "--columns"}, description="List of columns")
    List<String> columns;

    public ScanCommand(Logger console) {
        super(console);
    }

    @Override
    public int run() throws IOException {
        Preconditions.checkArgument((this.sourceFile != null && !this.sourceFile.isEmpty() ? 1 : 0) != 0, (Object)"Missing file name");
        Schema schema = this.getAvroSchema(this.sourceFile);
        Schema projection = Expressions.filterSchema(schema, this.columns);
        long startTime = System.currentTimeMillis();
        Iterable reader = this.openDataFile(this.sourceFile, projection);
        boolean threw = true;
        long count = 0L;
        try {
            for (Object record : reader) {
                ++count;
            }
            threw = false;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Failed on record " + count, e);
        }
        finally {
            if (reader instanceof Closeable) {
                Closeables.close((Closeable)((Closeable)((Object)reader)), (boolean)threw);
            }
        }
        long endTime = System.currentTimeMillis();
        this.console.info("Scanned " + count + " records from " + this.sourceFile);
        this.console.info("Time: " + (double)(endTime - startTime) / 1000.0 + " s");
        return 0;
    }

    @Override
    public List<String> getExamples() {
        return Lists.newArrayList((Object[])new String[]{"# Scan all the records from file \"data.avro\":", "data.avro", "# Scan all the records from file \"data.parquet\":", "data.parquet"});
    }
}

