/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.cli.BaseCommand;
import org.apache.parquet.cli.Util;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Dictionary;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.page.DictionaryPageReadStore;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.slf4j.Logger;

@Parameters(commandDescription="Print dictionaries for a Parquet column")
public class ShowDictionaryCommand
extends BaseCommand {
    @Parameter(description="<parquet path>")
    List<String> targets;
    @Parameter(names={"-c", "--column"}, description="Column path", required=true)
    String column;

    public ShowDictionaryCommand(Logger console) {
        super(console);
    }

    @Override
    public int run() throws IOException {
        Preconditions.checkArgument((this.targets != null && this.targets.size() >= 1 ? 1 : 0) != 0, (Object)"A Parquet file is required.");
        Preconditions.checkArgument((this.targets.size() == 1 ? 1 : 0) != 0, (Object)"Cannot process multiple Parquet files.");
        String source = this.targets.get(0);
        try (ParquetFileReader reader = ParquetFileReader.open((Configuration)this.getConf(), (Path)this.qualifiedPath(source));){
            DictionaryPageReadStore dictionaryReader;
            MessageType schema = reader.getFileMetaData().getSchema();
            ColumnDescriptor descriptor = Util.descriptor(this.column, schema);
            PrimitiveType type = Util.primitive(this.column, schema);
            Preconditions.checkNotNull((Object)type);
            int rowGroup = 0;
            while ((dictionaryReader = reader.getNextDictionaryReader()) != null) {
                DictionaryPage page = dictionaryReader.readDictionaryPage(descriptor);
                if (page != null) {
                    this.console.info("\nRow group {} dictionary for \"{}\":", (Object)rowGroup, (Object)this.column);
                    Dictionary dict = page.getEncoding().initDictionary(descriptor, page);
                    this.printDictionary(dict, type);
                } else {
                    this.console.info("\nRow group {} has no dictionary for \"{}\"", (Object)rowGroup, (Object)this.column);
                }
                reader.skipNextRowGroup();
                ++rowGroup;
            }
        }
        this.console.info("");
        return 0;
    }

    private void printDictionary(Dictionary dict, PrimitiveType type) {
        block7: for (int i = 0; i <= dict.getMaxId(); ++i) {
            switch (type.getPrimitiveTypeName()) {
                case BINARY: {
                    if (type.getLogicalTypeAnnotation() instanceof LogicalTypeAnnotation.StringLogicalTypeAnnotation) {
                        this.console.info("{}: {}", (Object)String.format("%6d", i), (Object)Util.humanReadable(dict.decodeToBinary(i).toStringUsingUTF8(), 70));
                        continue block7;
                    }
                    this.console.info("{}: {}", (Object)String.format("%6d", i), (Object)Util.humanReadable(dict.decodeToBinary(i).getBytesUnsafe(), 70));
                    continue block7;
                }
                case INT32: {
                    this.console.info("{}: {}", (Object)String.format("%6d", i), (Object)dict.decodeToInt(i));
                    continue block7;
                }
                case INT64: {
                    this.console.info("{}: {}", (Object)String.format("%6d", i), (Object)dict.decodeToLong(i));
                    continue block7;
                }
                case FLOAT: {
                    this.console.info("{}: {}", (Object)String.format("%6d", i), (Object)Float.valueOf(dict.decodeToFloat(i)));
                    continue block7;
                }
                case DOUBLE: {
                    this.console.info("{}: {}", (Object)String.format("%6d", i), (Object)dict.decodeToDouble(i));
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("Unknown dictionary type: " + type.getPrimitiveTypeName());
                }
            }
        }
    }

    @Override
    public List<String> getExamples() {
        return Lists.newArrayList((Object[])new String[]{"# Show the dictionary for column 'col' from a Parquet file", "-c col sample.parquet"});
    }
}

