/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.commands;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.parquet.cli.BaseCommand;
import org.slf4j.Logger;

@Parameters(commandDescription="Print the Avro schema for a file")
public class SchemaCommand
extends BaseCommand {
    @Parameter(description="<parquet path>")
    List<String> targets;
    @Parameter(names={"-o", "--output"}, description="Output file path")
    String outputPath = null;
    @Parameter(names={"--overwrite"}, description="Overwrite the output file if it exists")
    boolean overwrite = false;
    @Parameter(names={"--parquet"}, description="Print a Parquet schema, without converting to Avro", hidden=true)
    boolean parquetSchema = false;

    public SchemaCommand(Logger console) {
        super(console);
    }

    @Override
    public int run() throws IOException {
        Preconditions.checkArgument((this.targets != null && this.targets.size() == 1 ? 1 : 0) != 0, (Object)"Parquet file is required.");
        if (this.targets.size() > 1) {
            Preconditions.checkArgument((this.outputPath == null ? 1 : 0) != 0, (Object)("Cannot output multiple schemas to file " + this.outputPath));
            for (String source : this.targets) {
                this.console.info("{}: {}", (Object)source, (Object)this.getSchema(source));
            }
        } else {
            String source = this.targets.get(0);
            if (this.outputPath != null) {
                try (FSDataOutputStream out = this.overwrite ? this.create(this.outputPath) : this.createWithNoOverwrite(this.outputPath);){
                    out.write(this.getSchema(source).getBytes(StandardCharsets.UTF_8));
                }
            } else {
                this.console.info(this.getSchema(source));
            }
        }
        return 0;
    }

    @Override
    public List<String> getExamples() {
        return Lists.newArrayList((Object[])new String[]{"# Print the Avro schema for a Parquet file", "sample.parquet", "# Print the Avro schema for an Avro file", "sample.avro", "# Print the Avro schema for a JSON file", "sample.json"});
    }

    private String getSchema(String source) throws IOException {
        if (this.parquetSchema) {
            return this.getParquetSchema(source);
        }
        return this.getAvroSchema(source).toString(true);
    }

    /*
     * Exception decompiling
     */
    private String getParquetSchema(String source) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

