/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.util;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileStream;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.parquet.cli.json.AvroJson;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.NullNode;

public class Schemas {
    private static final Schema NULL = Schema.create((Schema.Type)Schema.Type.NULL);
    private static final NullNode NULL_DEFAULT = NullNode.getInstance();
    private static float SIMILARITY_THRESH = 0.3f;

    public static Schema fromAvsc(InputStream in) throws IOException {
        return new Schema.Parser().parse(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Schema fromAvro(InputStream in) throws IOException {
        Schema schema;
        GenericDatumReader datumReader = new GenericDatumReader();
        DataFileStream stream = null;
        boolean threw = true;
        try {
            stream = new DataFileStream(in, (DatumReader)datumReader);
            Schema schema2 = stream.getSchema();
            threw = false;
            schema = schema2;
        }
        catch (Throwable throwable) {
            Closeables.close(stream, (boolean)threw);
            throw throwable;
        }
        Closeables.close((Closeable)stream, (boolean)threw);
        return schema;
    }

    public static Schema fromParquet(Configuration conf, URI location) throws IOException {
        Path path = new Path(location);
        FileSystem fs = path.getFileSystem(conf);
        ParquetMetadata footer = ParquetFileReader.readFooter((Configuration)fs.getConf(), (Path)path);
        String schemaString = (String)footer.getFileMetaData().getKeyValueMetaData().get("parquet.avro.schema");
        if (schemaString == null) {
            schemaString = (String)footer.getFileMetaData().getKeyValueMetaData().get("avro.schema");
        }
        if (schemaString != null) {
            return new Schema.Parser().parse(schemaString);
        }
        return new AvroSchemaConverter().convert(footer.getFileMetaData().getSchema());
    }

    public static Schema fromJSON(String name, InputStream in) throws IOException {
        return AvroJson.inferSchema(in, name, 20);
    }

    public static boolean nullOk(Schema schema) {
        if (Schema.Type.NULL == schema.getType()) {
            return true;
        }
        if (Schema.Type.UNION == schema.getType()) {
            for (Schema possible : schema.getTypes()) {
                if (!Schemas.nullOk(possible)) continue;
                return true;
            }
        }
        return false;
    }

    public static Schema merge(Iterable<Schema> schemas) {
        Iterator<Schema> iter = schemas.iterator();
        if (!iter.hasNext()) {
            return null;
        }
        Schema result = iter.next();
        while (iter.hasNext()) {
            result = Schemas.merge(result, iter.next());
        }
        return result;
    }

    public static Schema mergeOrUnion(Iterable<Schema> schemas) {
        Iterator<Schema> iter = schemas.iterator();
        if (!iter.hasNext()) {
            return null;
        }
        Schema result = iter.next();
        while (iter.hasNext()) {
            result = Schemas.mergeOrUnion(result, iter.next());
        }
        return result;
    }

    public static Schema merge(Schema left, Schema right) {
        Schema merged = Schemas.mergeOnly(left, right);
        Preconditions.checkState((merged != null ? 1 : 0) != 0, (String)"Cannot merge %s and %s", (Object)left, (Object)right);
        return merged;
    }

    private static Schema mergeOrUnion(Schema left, Schema right) {
        Schema merged = Schemas.mergeOnly(left, right);
        if (merged != null) {
            return merged;
        }
        return Schemas.union(left, right);
    }

    private static Schema union(Schema left, Schema right) {
        if (left.getType() == Schema.Type.UNION) {
            if (right.getType() == Schema.Type.UNION) {
                Schema combined = left;
                for (Schema type : right.getTypes()) {
                    combined = Schemas.union(combined, type);
                }
                return combined;
            }
            boolean notMerged = true;
            ArrayList types = Lists.newArrayList();
            Iterator schemas = left.getTypes().iterator();
            while (schemas.hasNext()) {
                Schema next = (Schema)schemas.next();
                Schema merged = Schemas.mergeOnly(next, right);
                if (merged != null) {
                    types.add(merged);
                    notMerged = false;
                    break;
                }
                types.add(next);
            }
            while (schemas.hasNext()) {
                types.add(schemas.next());
            }
            if (notMerged) {
                types.add(right);
            }
            return Schema.createUnion((List)types);
        }
        if (right.getType() == Schema.Type.UNION) {
            return Schemas.union(right, left);
        }
        return Schema.createUnion((List)ImmutableList.of((Object)left, (Object)right));
    }

    private static Schema mergeOnly(Schema left, Schema right) {
        if (Objects.equal((Object)left, (Object)right)) {
            return left;
        }
        switch (left.getType()) {
            case INT: {
                if (right.getType() != Schema.Type.LONG) break;
                return right;
            }
            case LONG: {
                if (right.getType() != Schema.Type.INT) break;
                return left;
            }
            case FLOAT: {
                if (right.getType() != Schema.Type.DOUBLE) break;
                return right;
            }
            case DOUBLE: {
                if (right.getType() != Schema.Type.FLOAT) break;
                return left;
            }
        }
        if (left.getType() != right.getType()) {
            return null;
        }
        switch (left.getType()) {
            case UNION: {
                return Schemas.union(left, right);
            }
            case RECORD: {
                if (left.getName() == null && right.getName() == null && Schemas.fieldSimilarity(left, right) < SIMILARITY_THRESH) {
                    return null;
                }
                if (!Objects.equal((Object)left.getName(), (Object)right.getName())) {
                    return null;
                }
                Schema combinedRecord = Schema.createRecord((String)Schemas.coalesce(left.getName(), right.getName()), (String)Schemas.coalesce(left.getDoc(), right.getDoc()), (String)Schemas.coalesce(left.getNamespace(), right.getNamespace()), (boolean)false);
                combinedRecord.setFields(Schemas.mergeFields(left, right));
                return combinedRecord;
            }
            case MAP: {
                return Schema.createMap((Schema)Schemas.mergeOrUnion(left.getValueType(), right.getValueType()));
            }
            case ARRAY: {
                return Schema.createArray((Schema)Schemas.mergeOrUnion(left.getElementType(), right.getElementType()));
            }
            case ENUM: {
                if (!Objects.equal((Object)left.getName(), (Object)right.getName())) {
                    return null;
                }
                LinkedHashSet symbols = Sets.newLinkedHashSet();
                symbols.addAll(left.getEnumSymbols());
                symbols.addAll(right.getEnumSymbols());
                return Schema.createEnum((String)left.getName(), (String)Schemas.coalesce(left.getDoc(), right.getDoc()), (String)Schemas.coalesce(left.getNamespace(), right.getNamespace()), (List)ImmutableList.copyOf((Collection)symbols));
            }
        }
        throw new UnsupportedOperationException("Unknown schema type: " + left.getType());
    }

    private static Schema nullableForDefault(Schema schema) {
        if (schema.getType() == Schema.Type.NULL) {
            return schema;
        }
        if (schema.getType() != Schema.Type.UNION) {
            return Schema.createUnion((List)ImmutableList.of((Object)NULL, (Object)schema));
        }
        if (((Schema)schema.getTypes().get(0)).getType() == Schema.Type.NULL) {
            return schema;
        }
        ArrayList types = Lists.newArrayList();
        types.add(NULL);
        for (Schema type : schema.getTypes()) {
            if (type.getType() == Schema.Type.NULL) continue;
            types.add(type);
        }
        return Schema.createUnion((List)types);
    }

    private static List<Schema.Field> mergeFields(Schema left, Schema right) {
        ArrayList fields = Lists.newArrayList();
        for (Schema.Field leftField : left.getFields()) {
            Schema.Field rightField = right.getField(leftField.name());
            if (rightField != null) {
                fields.add(new Schema.Field(leftField.name(), Schemas.mergeOrUnion(leftField.schema(), rightField.schema()), Schemas.coalesce(leftField.doc(), rightField.doc()), Schemas.coalesce(leftField.defaultValue(), rightField.defaultValue())));
                continue;
            }
            if (leftField.defaultValue() != null) {
                fields.add(Schemas.copy(leftField));
                continue;
            }
            fields.add(new Schema.Field(leftField.name(), Schemas.nullableForDefault(leftField.schema()), leftField.doc(), (JsonNode)NULL_DEFAULT));
        }
        for (Schema.Field rightField : right.getFields()) {
            if (left.getField(rightField.name()) != null) continue;
            if (rightField.defaultValue() != null) {
                fields.add(Schemas.copy(rightField));
                continue;
            }
            fields.add(new Schema.Field(rightField.name(), Schemas.nullableForDefault(rightField.schema()), rightField.doc(), (JsonNode)NULL_DEFAULT));
        }
        return fields;
    }

    public static Schema.Field copy(Schema.Field field) {
        return new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultValue());
    }

    private static float fieldSimilarity(Schema left, Schema right) {
        Set<String> leftNames = Schemas.names(left.getFields());
        Set<String> rightNames = Schemas.names(right.getFields());
        int common = Sets.intersection(leftNames, rightNames).size();
        float leftRatio = (float)common / (float)leftNames.size();
        float rightRatio = (float)common / (float)rightNames.size();
        return Schemas.hmean(leftRatio, rightRatio);
    }

    private static Set<String> names(Collection<Schema.Field> fields) {
        HashSet names = Sets.newHashSet();
        for (Schema.Field field : fields) {
            names.add(field.name());
        }
        return names;
    }

    private static float hmean(float left, float right) {
        return 2.0f * left * right / (left + right);
    }

    @SafeVarargs
    private static <E> E coalesce(E ... objects) {
        for (E object : objects) {
            if (object == null) continue;
            return object;
        }
        return null;
    }
}

