/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.cli.util;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;

public class Expressions {
    private static final Pattern NUMERIC_RE = Pattern.compile("^\\d+$");

    public static Object select(Schema schema, Object datum, String path) {
        return Expressions.select(schema, datum, Lists.newArrayList((Object[])new PathExpr[]{Expressions.parse(path)}));
    }

    private static Object select(Schema schema, Object datum, List<PathExpr> tokens) {
        if (tokens.isEmpty()) {
            return datum;
        }
        Preconditions.checkArgument((tokens.size() == 1 ? 1 : 0) != 0, (Object)"Cannot return multiple values");
        PathExpr token = tokens.get(0);
        switch (schema.getType()) {
            case RECORD: {
                if (!(datum instanceof GenericRecord) && "json".equals(schema.getName())) {
                    return Expressions.select(schema.getField("value").schema(), datum, tokens);
                }
                Preconditions.checkArgument((token.type == PathExpr.Type.FIELD ? 1 : 0) != 0, (Object)"Cannot dereference records");
                Preconditions.checkArgument((boolean)(datum instanceof GenericRecord), (String)"Not a record: %s", (Object)datum);
                GenericRecord record = (GenericRecord)datum;
                Schema.Field field = schema.getField(token.value);
                Preconditions.checkArgument((field != null ? 1 : 0) != 0, (String)"No such field '%s' in schema: %s", (Object)token.value, (Object)schema);
                return Expressions.select(field.schema(), record.get(token.value), token.children);
            }
            case MAP: {
                Preconditions.checkArgument((boolean)(datum instanceof Map), (String)"Not a map: %s", (Object)datum);
                Map map = (Map)datum;
                Object value = map.get(token.value);
                if (value == null) {
                    value = map.get(new Utf8(token.value));
                }
                return Expressions.select(schema.getValueType(), value, token.children);
            }
            case ARRAY: {
                Preconditions.checkArgument((token.type == PathExpr.Type.DEREF ? 1 : 0) != 0, (Object)"Cannot access fields of an array");
                Preconditions.checkArgument((boolean)(datum instanceof Collection), (String)"Not an array: %s", (Object)datum);
                Preconditions.checkArgument((boolean)NUMERIC_RE.matcher(token.value).matches(), (String)"Not an array index: %s", (Object)token.value);
                List list = (List)datum;
                return Expressions.select(schema.getElementType(), list.get(Integer.parseInt(token.value)), token.children);
            }
            case UNION: {
                int branch = GenericData.get().resolveUnion(schema, datum);
                return Expressions.select((Schema)schema.getTypes().get(branch), datum, tokens);
            }
        }
        throw new IllegalArgumentException("Cannot access child of primitive value: " + datum);
    }

    public static Schema filterSchema(Schema schema, String ... fieldPaths) {
        return Expressions.filterSchema(schema, Lists.newArrayList((Object[])fieldPaths));
    }

    public static Schema filterSchema(Schema schema, List<String> fieldPaths) {
        if (fieldPaths == null) {
            return schema;
        }
        List<PathExpr> paths = Expressions.merge(Lists.newArrayList(fieldPaths));
        return Expressions.filter(schema, paths);
    }

    private static PathExpr parse(String path) {
        PathExpr expr = null;
        PathExpr last = null;
        boolean inDeref = false;
        boolean afterDeref = false;
        int valueStart = 0;
        block5: for (int i = 0; i < path.length(); ++i) {
            switch (path.charAt(i)) {
                case '.': {
                    PathExpr current;
                    Preconditions.checkState((valueStart != i || afterDeref ? 1 : 0) != 0, (Object)"Empty reference: ''");
                    if (inDeref) continue block5;
                    if (valueStart != i) {
                        current = PathExpr.field(path.substring(valueStart, i));
                        if (last != null) {
                            last.children.add(current);
                        } else {
                            expr = current;
                        }
                        last = current;
                    }
                    valueStart = i + 1;
                    afterDeref = false;
                    continue block5;
                }
                case '[': {
                    PathExpr current;
                    Preconditions.checkState((!inDeref ? 1 : 0) != 0, (Object)"Cannot nest [ within []");
                    Preconditions.checkState((valueStart != i || afterDeref ? 1 : 0) != 0, (Object)"Empty reference: ''");
                    if (valueStart != i) {
                        current = PathExpr.field(path.substring(valueStart, i));
                        if (last != null) {
                            last.children.add(current);
                        } else {
                            expr = current;
                        }
                        last = current;
                    }
                    valueStart = i + 1;
                    inDeref = true;
                    afterDeref = false;
                    continue block5;
                }
                case ']': {
                    Preconditions.checkState((boolean)inDeref, (Object)"Cannot use ] without a starting [");
                    Preconditions.checkState((valueStart != i ? 1 : 0) != 0, (Object)"Empty reference: ''");
                    PathExpr current = PathExpr.deref(path.substring(valueStart, i));
                    if (last != null) {
                        last.children.add(current);
                    } else {
                        expr = current;
                    }
                    last = current;
                    valueStart = i + 1;
                    inDeref = false;
                    afterDeref = true;
                    continue block5;
                }
                default: {
                    Preconditions.checkState((!afterDeref ? 1 : 0) != 0, (Object)"Fields after [] must start with .");
                }
            }
        }
        Preconditions.checkState((!inDeref ? 1 : 0) != 0, (Object)"Fields after [ must end with ]");
        if (valueStart < path.length()) {
            PathExpr current = PathExpr.field(path.substring(valueStart, path.length()));
            if (last != null) {
                last.children.add(current);
            } else {
                expr = current;
            }
        }
        return expr;
    }

    private static List<PathExpr> merge(List<String> fields) {
        ArrayList paths = Lists.newArrayList();
        for (String field : fields) {
            Expressions.merge(paths, Expressions.parse(field));
        }
        return paths;
    }

    private static List<PathExpr> merge(List<PathExpr> tokens, PathExpr toAdd) {
        boolean merged = false;
        for (PathExpr token : tokens) {
            if (token.type != toAdd.type || token.type != PathExpr.Type.DEREF && !token.value.equals(toAdd.value)) continue;
            for (PathExpr child : toAdd.children) {
                Expressions.merge(token.children, child);
            }
            merged = true;
        }
        if (!merged) {
            tokens.add(toAdd);
        }
        return tokens;
    }

    private static Schema filter(Schema schema, List<PathExpr> exprs) {
        if (exprs.isEmpty()) {
            return schema;
        }
        switch (schema.getType()) {
            case RECORD: {
                ArrayList fields = Lists.newArrayList();
                for (PathExpr expr : exprs) {
                    Schema.Field field = schema.getField(expr.value);
                    Preconditions.checkArgument((field != null ? 1 : 0) != 0, (String)"Cannot find field '%s' in schema: %s", (Object)expr.value, (Object)schema);
                    fields.add(new Schema.Field(expr.value, Expressions.filter(field.schema(), expr.children), field.doc(), field.defaultVal(), field.order()));
                }
                return Schema.createRecord((String)schema.getName(), (String)schema.getDoc(), (String)schema.getNamespace(), (boolean)schema.isError(), (List)fields);
            }
            case UNION: {
                if (schema.getTypes().size() == 2) {
                    if (((Schema)schema.getTypes().get(0)).getType() == Schema.Type.NULL) {
                        return Expressions.filter((Schema)schema.getTypes().get(1), exprs);
                    }
                    if (((Schema)schema.getTypes().get(1)).getType() == Schema.Type.NULL) {
                        return Expressions.filter((Schema)schema.getTypes().get(0), exprs);
                    }
                }
                ArrayList schemas = Lists.newArrayList();
                for (PathExpr expr : exprs) {
                    schemas.add(Expressions.filter(schema, expr));
                }
                if (schemas.size() > 1) {
                    return Schema.createUnion((List)schemas);
                }
                return (Schema)schemas.get(0);
            }
            case MAP: {
                Preconditions.checkArgument((exprs.size() == 1 ? 1 : 0) != 0, (String)"Cannot find multiple children of map schema: %s", (Object)schema);
                return Expressions.filter(schema, exprs.get(0));
            }
            case ARRAY: {
                Preconditions.checkArgument((exprs.size() == 1 ? 1 : 0) != 0, (String)"Cannot find multiple children of array schema: %s", (Object)schema);
                return Expressions.filter(schema, exprs.get(0));
            }
        }
        throw new IllegalArgumentException(String.format("Cannot find child of primitive schema: %s", schema));
    }

    private static Schema filter(Schema schema, PathExpr expr) {
        if (expr == null) {
            return schema;
        }
        switch (schema.getType()) {
            case RECORD: {
                Preconditions.checkArgument((expr.type == PathExpr.Type.FIELD ? 1 : 0) != 0, (String)"Cannot index a record: [%s]", (Object)expr.value);
                Schema.Field field = schema.getField(expr.value);
                if (field != null) {
                    return Expressions.filter(field.schema(), expr.children);
                }
                throw new IllegalArgumentException(String.format("Cannot find field '%s' in schema: %s", expr.value, schema.toString(true)));
            }
            case MAP: {
                return Schema.createMap((Schema)Expressions.filter(schema.getValueType(), expr.children));
            }
            case ARRAY: {
                Preconditions.checkArgument((expr.type == PathExpr.Type.DEREF ? 1 : 0) != 0, (String)"Cannot find field '%s' in an array", (Object)expr.value);
                Preconditions.checkArgument((boolean)NUMERIC_RE.matcher(expr.value).matches(), (String)"Cannot index array by non-numeric value '%s'", (Object)expr.value);
                return Schema.createArray((Schema)Expressions.filter(schema.getElementType(), expr.children));
            }
            case UNION: {
                Preconditions.checkArgument((expr.type == PathExpr.Type.DEREF ? 1 : 0) != 0, (String)"Cannot find field '%s' in a union", (Object)expr.value);
                List options = schema.getTypes();
                if (NUMERIC_RE.matcher(expr.value).matches()) {
                    int i = Integer.parseInt(expr.value);
                    if (i < options.size()) {
                        return Expressions.filter((Schema)options.get(i), expr.children);
                    }
                } else {
                    for (Schema option : options) {
                        if (!expr.value.equalsIgnoreCase(option.getName())) continue;
                        return Expressions.filter(option, expr.children);
                    }
                }
                throw new IllegalArgumentException(String.format("Invalid union index '%s' for schema: %s", expr.value, schema));
            }
        }
        throw new IllegalArgumentException(String.format("Cannot find '%s' in primitive schema: %s", expr.value, schema));
    }

    private static class PathExpr {
        private final Type type;
        private final String value;
        private final List<PathExpr> children;

        static PathExpr deref(String value) {
            return new PathExpr(Type.DEREF, value);
        }

        static PathExpr deref(String value, PathExpr child) {
            return new PathExpr(Type.DEREF, value, Lists.newArrayList((Object[])new PathExpr[]{child}));
        }

        static PathExpr field(String value) {
            return new PathExpr(Type.FIELD, value);
        }

        static PathExpr field(String value, PathExpr child) {
            return new PathExpr(Type.FIELD, value, Lists.newArrayList((Object[])new PathExpr[]{child}));
        }

        PathExpr(Type type, String value) {
            this.type = type;
            this.value = value;
            this.children = Lists.newArrayList();
        }

        PathExpr(Type type, String value, List<PathExpr> children) {
            this.type = type;
            this.value = value;
            this.children = children;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PathExpr pathExpr = (PathExpr)o;
            if (this.type != pathExpr.type) {
                return false;
            }
            if (this.value != null ? !this.value.equals(pathExpr.value) : pathExpr.value != null) {
                return false;
            }
            return this.children != null ? this.children.equals(pathExpr.children) : pathExpr.children == null;
        }

        public int hashCode() {
            int result = this.type != null ? this.type.hashCode() : 0;
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            result = 31 * result + (this.children != null ? this.children.hashCode() : 0);
            return result;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("type", (Object)this.type).add("value", (Object)this.value).add("children", this.children).toString();
        }

        static enum Type {
            DEREF,
            FIELD;

        }
    }
}

