/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.service.server;

import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import org.apache.paimon.query.QueryServer;
import org.apache.paimon.service.messages.KvRequest;
import org.apache.paimon.service.messages.KvResponse;
import org.apache.paimon.service.network.AbstractServerHandler;
import org.apache.paimon.service.network.NetworkServer;
import org.apache.paimon.service.network.messages.MessageDeserializer;
import org.apache.paimon.service.network.messages.MessageSerializer;
import org.apache.paimon.service.network.stats.ServiceRequestStats;
import org.apache.paimon.service.server.KvServerHandler;
import org.apache.paimon.table.query.TableQuery;
import org.apache.paimon.utils.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KvQueryServer
extends NetworkServer<KvRequest, KvResponse>
implements QueryServer {
    private static final Logger LOG = LoggerFactory.getLogger(KvQueryServer.class);
    private final int serverId;
    private final int numServers;
    private final TableQuery lookup;
    private final ServiceRequestStats stats;

    public KvQueryServer(int serverId, int numServers, String bindAddress, Iterator<Integer> bindPortIterator, Integer numEventLoopThreads, Integer numQueryThreads, TableQuery lookup, ServiceRequestStats stats) {
        super("Kv Query Server", bindAddress, bindPortIterator, numEventLoopThreads, numQueryThreads);
        this.serverId = serverId;
        this.numServers = numServers;
        this.stats = (ServiceRequestStats)Preconditions.checkNotNull((Object)stats);
        this.lookup = (TableQuery)Preconditions.checkNotNull((Object)lookup);
    }

    public AbstractServerHandler<KvRequest, KvResponse> initializeHandler() {
        MessageSerializer serializer = new MessageSerializer((MessageDeserializer)new KvRequest.KvRequestDeserializer(), (MessageDeserializer)new KvResponse.KvResponseDeserializer());
        return new KvServerHandler(this, this.serverId, this.numServers, this.lookup, (MessageSerializer<KvRequest, KvResponse>)serializer, this.stats);
    }

    public void start() throws Throwable {
        super.start();
    }

    public InetSocketAddress getServerAddress() {
        return super.getServerAddress();
    }

    public void shutdown() {
        try {
            this.shutdownServer().get(10L, TimeUnit.SECONDS);
            LOG.info("{} was shutdown successfully.", (Object)this.getServerName());
        }
        catch (Exception e) {
            LOG.warn("{} shutdown failed: {}", (Object)this.getServerName(), (Object)e);
        }
    }
}

