/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.paimon.shade.guava30.com.google.common.util.concurrent.ForwardingExecutorService;
import org.apache.paimon.shade.guava30.com.google.common.util.concurrent.Futures;

public class SemaphoredDelegatingExecutor
extends ForwardingExecutorService {
    private final Semaphore queueingPermits;
    private final ExecutorService executorDelegated;
    private final int permitCount;

    public SemaphoredDelegatingExecutor(ExecutorService executorDelegated, int permitCount, boolean fair) {
        this.permitCount = permitCount;
        this.queueingPermits = new Semaphore(permitCount, fair);
        this.executorDelegated = executorDelegated;
    }

    @Override
    protected ExecutorService delegate() {
        return this.executorDelegated;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        try {
            this.queueingPermits.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return Futures.immediateFailedFuture(e);
        }
        return super.submit(new CallableWithPermitRelease<T>(task));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        try {
            this.queueingPermits.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return Futures.immediateFailedFuture(e);
        }
        return super.submit(new RunnableWithPermitRelease(task), result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        try {
            this.queueingPermits.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return Futures.immediateFailedFuture(e);
        }
        return super.submit(new RunnableWithPermitRelease(task));
    }

    @Override
    public void execute(Runnable command) {
        try {
            this.queueingPermits.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        super.execute(new RunnableWithPermitRelease(command));
    }

    public int getAvailablePermits() {
        return this.queueingPermits.availablePermits();
    }

    public int getWaitingCount() {
        return this.queueingPermits.getQueueLength();
    }

    public int getPermitCount() {
        return this.permitCount;
    }

    @Override
    public String toString() {
        return "SemaphoredDelegatingExecutor{permitCount=" + this.getPermitCount() + ", available=" + this.getAvailablePermits() + ", waiting=" + this.getWaitingCount() + "}";
    }

    private class CallableWithPermitRelease<T>
    implements Callable<T> {
        private final Callable<T> delegated;

        CallableWithPermitRelease(Callable<T> delegated) {
            this.delegated = delegated;
        }

        @Override
        public T call() throws Exception {
            T result;
            try {
                result = this.delegated.call();
            }
            finally {
                SemaphoredDelegatingExecutor.this.queueingPermits.release();
            }
            return result;
        }
    }

    private class RunnableWithPermitRelease
    implements Runnable {
        private final Runnable delegated;

        RunnableWithPermitRelease(Runnable delegated) {
            this.delegated = delegated;
        }

        @Override
        public void run() {
            try {
                this.delegated.run();
            }
            finally {
                SemaphoredDelegatingExecutor.this.queueingPermits.release();
            }
        }
    }
}

