/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;
import org.apache.paimon.annotation.VisibleForTesting;
import org.apache.paimon.shade.org.roaringbitmap.longlong.Roaring64Bitmap;

public class RoaringBitmap64 {
    private final Roaring64Bitmap roaringBitmap = new Roaring64Bitmap();

    public void add(long x) {
        this.roaringBitmap.add(x);
    }

    public void or(RoaringBitmap64 other) {
        this.roaringBitmap.or(other.roaringBitmap);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoaringBitmap64 that = (RoaringBitmap64)o;
        return Objects.equals(this.roaringBitmap, that.roaringBitmap);
    }

    public void clear() {
        this.roaringBitmap.clear();
    }

    public byte[] serialize() throws IOException {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (DataOutputStream dos = new DataOutputStream(bos);){
                this.roaringBitmap.runOptimize();
                this.roaringBitmap.serialize(dos);
                byArray = bos.toByteArray();
            }
            return byArray;
        }
    }

    public void deserialize(byte[] rbmBytes) throws IOException {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(rbmBytes);
             DataInputStream dis = new DataInputStream(bis);){
            this.roaringBitmap.deserialize(dis);
        }
    }

    @VisibleForTesting
    public static RoaringBitmap64 bitmapOf(long ... dat) {
        RoaringBitmap64 roaringBitmap64 = new RoaringBitmap64();
        for (long ele : dat) {
            roaringBitmap64.add(ele);
        }
        return roaringBitmap64;
    }
}

