/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import javax.annotation.Nullable;
import org.apache.paimon.Snapshot;
import org.apache.paimon.table.source.OutOfRangeException;
import org.apache.paimon.utils.ChangelogManager;
import org.apache.paimon.utils.SnapshotManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NextSnapshotFetcher {
    public static final Logger LOG = LoggerFactory.getLogger(NextSnapshotFetcher.class);
    public static final int RANGE_CHECK_INTERVAL = 16;
    private final SnapshotManager snapshotManager;
    private final ChangelogManager changelogManager;
    private final boolean changelogDecoupled;
    private int rangeCheckCnt = 0;

    public NextSnapshotFetcher(SnapshotManager snapshotManager, ChangelogManager changelogManager, boolean changelogDecoupled) {
        this.snapshotManager = snapshotManager;
        this.changelogManager = changelogManager;
        this.changelogDecoupled = changelogDecoupled;
    }

    @Nullable
    public Snapshot getNextSnapshot(long nextSnapshotId) {
        if (this.snapshotManager.snapshotExists(nextSnapshotId)) {
            this.rangeCheckCnt = 0;
            return this.snapshotManager.snapshot(nextSnapshotId);
        }
        if (this.changelogDecoupled && this.changelogManager.longLivedChangelogExists(nextSnapshotId)) {
            return this.changelogManager.changelog(nextSnapshotId);
        }
        ++this.rangeCheckCnt;
        if (this.rangeCheckCnt % 16 == 0) {
            this.rangeCheck(nextSnapshotId);
        }
        return null;
    }

    private void rangeCheck(long nextSnapshotId) {
        Long earliestSnapshotId = this.snapshotManager.earliestSnapshotId();
        Long latestSnapshotId = this.snapshotManager.latestSnapshotIdFromFileSystem();
        if (earliestSnapshotId == null || earliestSnapshotId <= nextSnapshotId) {
            if (earliestSnapshotId == null && nextSnapshotId > 1L || latestSnapshotId != null && nextSnapshotId > latestSnapshotId + 1L) {
                throw new OutOfRangeException(String.format("The next expected snapshot is too big! Most possible cause might be the table had been recreated.The next snapshot id is %d, while the latest snapshot id is %s", nextSnapshotId, latestSnapshotId));
            }
            LOG.debug("Next snapshot id {} does not exist, wait for the snapshot generation.", (Object)nextSnapshotId);
        } else if (!this.changelogDecoupled) {
            throw new OutOfRangeException(String.format("The snapshot with id %d has expired. You can: 1. increase the snapshot or changelog expiration time. 2. use consumer-id to ensure that unconsumed snapshots will not be expired.", nextSnapshotId));
        }
    }
}

