/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.util.HashMap;

public final class InstantiationUtil {
    public static <T> T deserializeObject(byte[] bytes, ClassLoader cl) throws IOException, ClassNotFoundException {
        return InstantiationUtil.deserializeObject(new ByteArrayInputStream(bytes), cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T deserializeObject(InputStream in, ClassLoader cl) throws IOException, ClassNotFoundException {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoaderObjectInputStream oois = new ClassLoaderObjectInputStream(in, cl);
            Thread.currentThread().setContextClassLoader(cl);
            Object object = oois.readObject();
            return (T)object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    public static byte[] serializeObject(Object o) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(o);
                oos.flush();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
    }

    public static void serializeObject(OutputStream out, Object o) throws IOException {
        ObjectOutputStream oos = out instanceof ObjectOutputStream ? (ObjectOutputStream)out : new ObjectOutputStream(out);
        oos.writeObject(o);
    }

    public static <T extends Serializable> T clone(T obj) throws IOException, ClassNotFoundException {
        if (obj == null) {
            return null;
        }
        return InstantiationUtil.clone(obj, obj.getClass().getClassLoader());
    }

    public static <T extends Serializable> T clone(T obj, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        if (obj == null) {
            return null;
        }
        byte[] serializedObject = InstantiationUtil.serializeObject(obj);
        return (T)((Serializable)InstantiationUtil.deserializeObject(serializedObject, classLoader));
    }

    private InstantiationUtil() {
        throw new RuntimeException();
    }

    public static class ClassLoaderObjectInputStream
    extends ObjectInputStream {
        protected final ClassLoader classLoader;
        private static final HashMap<String, Class<?>> primitiveClasses = new HashMap(9);

        public ClassLoaderObjectInputStream(InputStream in, ClassLoader classLoader) throws IOException {
            super(in);
            this.classLoader = classLoader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            if (this.classLoader != null) {
                String name = desc.getName();
                try {
                    return Class.forName(name, false, this.classLoader);
                }
                catch (ClassNotFoundException ex) {
                    Class<?> cl = primitiveClasses.get(name);
                    if (cl != null) {
                        return cl;
                    }
                    throw ex;
                }
            }
            return super.resolveClass(desc);
        }

        @Override
        protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
            if (this.classLoader != null) {
                ClassLoader nonPublicLoader = null;
                boolean hasNonPublicInterface = false;
                Class[] classObjs = new Class[interfaces.length];
                for (int i = 0; i < interfaces.length; ++i) {
                    Class<?> cl = Class.forName(interfaces[i], false, this.classLoader);
                    if ((cl.getModifiers() & 1) == 0) {
                        if (hasNonPublicInterface) {
                            if (nonPublicLoader != cl.getClassLoader()) {
                                throw new IllegalAccessError("conflicting non-public interface class loaders");
                            }
                        } else {
                            nonPublicLoader = cl.getClassLoader();
                            hasNonPublicInterface = true;
                        }
                    }
                    classObjs[i] = cl;
                }
                try {
                    return Proxy.getProxyClass(hasNonPublicInterface ? nonPublicLoader : this.classLoader, classObjs);
                }
                catch (IllegalArgumentException e) {
                    throw new ClassNotFoundException(null, e);
                }
            }
            return super.resolveProxyClass(interfaces);
        }

        static {
            primitiveClasses.put("boolean", Boolean.TYPE);
            primitiveClasses.put("byte", Byte.TYPE);
            primitiveClasses.put("char", Character.TYPE);
            primitiveClasses.put("short", Short.TYPE);
            primitiveClasses.put("int", Integer.TYPE);
            primitiveClasses.put("long", Long.TYPE);
            primitiveClasses.put("float", Float.TYPE);
            primitiveClasses.put("double", Double.TYPE);
            primitiveClasses.put("void", Void.TYPE);
        }
    }
}

